<?php
/**
 * Venue - Settings
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireVenue();

// Check permission to view settings
if (!hasPermission('venue.settings.view')) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/venue/dashboard.php?error=' . urlencode('You do not have permission to view settings.'));
    exit;
}

$venue = getCurrentVenue();
$user = getCurrentUser();
$pdo = getDB();

$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings | Venue Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="venue-panel">
    <?php 
    $current_page = 'settings';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Settings</h1>
                
                <!-- Venue Settings -->
                <div class="section">
                    <h2>Venue Settings</h2>
                    <form>
                        <div class="form-group">
                            <label>Venue Name</label>
                            <input type="text" value="<?php echo htmlspecialchars($venue['venue_name']); ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label>Capacity</label>
                            <input type="number" value="<?php echo $venue['capacity'] ?? ''; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label>Verification Status</label>
                            <input type="text" value="<?php echo ucfirst($venue['verification_status']); ?>" readonly>
                        </div>
                        <p style="color: #6b7280; margin-top: 1rem;">
                            To update venue information, please go to <a href="profile.php">Venue Profile</a>.
                        </p>
                    </form>
                </div>
                
                <!-- Notification Settings -->
                <div class="section">
                    <h2>Notification Preferences</h2>
                    <form>
                        <div class="form-group">
                            <label>
                                <input type="checkbox" checked> Email notifications for new events
                            </label>
                        </div>
                        <div class="form-group">
                            <label>
                                <input type="checkbox" checked> SMS notifications for urgent updates
                            </label>
                        </div>
                        <div class="form-group">
                            <label>
                                <input type="checkbox" checked> Push notifications for bookings
                            </label>
                        </div>
                        <button type="submit" class="btn-sm btn-primary">Save Preferences</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
    
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
</body>
</html>

