<?php
/**
 * Venue - Venue Profile
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireVenue();

// Check permission to view profile
if (!hasPermission('venue.profile.view')) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/venue/dashboard.php?error=' . urlencode('You do not have permission to view profile.'));
    exit;
}

$venue = getCurrentVenue();
$user = getCurrentUser();
$pdo = getDB();

$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Venue Profile | Venue Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="venue-panel">
    <?php 
    $current_page = 'profile';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Venue Profile</h1>
                
                <!-- Venue Information -->
                <div class="section">
                    <h2>Venue Information</h2>
                    <form method="POST" action="<?php echo $baseUrl; ?>/api/venue/updateprofileapi.php">
                        <div class="form-group">
                            <label for="venue_name">Venue Name *</label>
                            <input type="text" id="venue_name" name="venue_name" value="<?php echo htmlspecialchars($venue['venue_name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea id="description" name="description" rows="4"><?php echo htmlspecialchars($venue['description'] ?? ''); ?></textarea>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                            <div class="form-group">
                                <label for="contact_email">Contact Email *</label>
                                <input type="email" id="contact_email" name="contact_email" value="<?php echo htmlspecialchars($venue['contact_email'] ?? $user['email']); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="tel" id="contact_phone" name="contact_phone" value="<?php echo htmlspecialchars($venue['contact_phone'] ?? ''); ?>">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="address">Address *</label>
                            <textarea id="address" name="address" rows="2" required><?php echo htmlspecialchars($venue['address']); ?></textarea>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1rem;">
                            <div class="form-group">
                                <label for="city">City *</label>
                                <input type="text" id="city" name="city" value="<?php echo htmlspecialchars($venue['city']); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="state">State</label>
                                <input type="text" id="state" name="state" value="<?php echo htmlspecialchars($venue['state'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="country">Country *</label>
                                <input type="text" id="country" name="country" value="<?php echo htmlspecialchars($venue['country']); ?>" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="capacity">Capacity</label>
                            <input type="number" id="capacity" name="capacity" value="<?php echo $venue['capacity'] ?? ''; ?>" min="1">
                        </div>
                        
                        <div class="form-group">
                            <label for="venue_rules">Venue Rules</label>
                            <textarea id="venue_rules" name="venue_rules" rows="3" placeholder="Enter venue rules and policies..."><?php echo htmlspecialchars($venue['venue_rules'] ?? ''); ?></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="accessibility_details">Accessibility Details</label>
                            <textarea id="accessibility_details" name="accessibility_details" rows="3" placeholder="Describe accessibility features..."><?php echo htmlspecialchars($venue['accessibility_details'] ?? ''); ?></textarea>
                        </div>
                        
                        <button type="submit" class="btn-sm btn-primary">Update Profile</button>
                    </form>
                </div>
                
                <!-- Verification Status -->
                <div class="section">
                    <h2>Verification Status</h2>
                    <p>
                        <strong>Status:</strong> 
                        <span class="status-badge status-<?php echo $venue['verification_status']; ?>">
                            <?php echo ucfirst($venue['verification_status']); ?>
                        </span>
                    </p>
                    <?php if ($venue['verification_status'] !== 'verified'): ?>
                        <p style="color: #6b7280; margin-top: 0.5rem;">
                            Your venue is pending verification. Please contact support to complete verification.
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
    
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
</body>
</html>

