<?php
/**
 * Venue - Events
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireVenue();

// Check permission to view events
if (!hasPermission('venue.events.view')) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/venue/dashboard.php?error=' . urlencode('You do not have permission to view events.'));
    exit;
}

$venue = getCurrentVenue();
$pdo = getDB();

// Get events at this venue
$stmt = $pdo->prepare("
    SELECT e.*, o.company_name as organizer_name
    FROM events e
    LEFT JOIN organizers o ON e.organizer_id = o.id
    WHERE e.venue_id = :venue_id
    ORDER BY e.start_date DESC
");
$stmt->execute([':venue_id' => $venue['id']]);
$events = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Events | Venue Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <?php $baseUrl = getCorrectBaseUrl(); ?>
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="venue-panel">
    <?php 
    $current_page = 'events';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Events at This Venue</h1>
                
                <div class="section">
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Event Name</th>
                                    <th>Organizer</th>
                                    <th>Start Date</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($events as $event): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($event['name']); ?></td>
                                    <td><?php echo htmlspecialchars($event['organizer_name'] ?? 'N/A'); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($event['start_date'])); ?></td>
                                    <td><span class="status-badge status-<?php echo $event['status']; ?>"><?php echo ucfirst($event['status']); ?></span></td>
                                    <td>
                                        <a href="event-detail.php?id=<?php echo $event['id']; ?>" class="btn-sm btn-primary">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
</body>
</html>

