<?php
/**
 * Venue - Access Control
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireVenue();

// Check permission to view access control
if (!hasPermission('venue.access.view')) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/venue/dashboard.php?error=' . urlencode('You do not have permission to view access control.'));
    exit;
}

$venue = getCurrentVenue();
$pdo = getDB();

// Get venue staff
$stmt = $pdo->prepare("
    SELECT 
        vs.*,
        c.full_name as staff_name,
        c.email as staff_email
    FROM venue_staff vs
    INNER JOIN customers c ON vs.user_id = c.id
    WHERE vs.venue_id = :venue_id
    ORDER BY vs.created_at DESC
");
$stmt->execute([':venue_id' => $venue['id']]);
$staff = $stmt->fetchAll();

$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Access Control | Venue Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="venue-panel">
    <?php 
    $current_page = 'access-control';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Access Control & Operations</h1>
                
                <!-- Staff Management -->
                <div class="section">
                    <h2>Staff Management</h2>
                    <p style="margin-bottom: 1.5rem; color: #6b7280;">
                        Manage staff members who can access this venue's operations and perform check-ins.
                    </p>
                    
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Staff Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Zones Access</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($staff)): ?>
                                <tr>
                                    <td colspan="6" style="text-align: center; padding: 2rem;">
                                        No staff members added yet. Add staff members to enable access control.
                                    </td>
                                </tr>
                                <?php else: ?>
                                    <?php foreach ($staff as $member): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($member['staff_name'] ?? 'N/A'); ?></td>
                                        <td><?php echo htmlspecialchars($member['staff_email']); ?></td>
                                        <td><?php echo ucfirst($member['role']); ?></td>
                                        <td><?php echo htmlspecialchars($member['zones_access'] ?? 'All Zones'); ?></td>
                                        <td>
                                            <?php if ($member['is_active']): ?>
                                                <span class="status-badge status-approved">Active</span>
                                            <?php else: ?>
                                                <span class="status-badge status-rejected">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="#" class="btn-sm btn-secondary">Edit</a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- QR Scan Permissions -->
                <div class="section">
                    <h2>QR Scan Permissions</h2>
                    <p style="margin-bottom: 1.5rem; color: #6b7280;">
                        Configure which staff members can scan QR codes for ticket validation.
                    </p>
                    <div style="background: #f3f4f6; padding: 1rem; border-radius: 8px;">
                        <p><strong>Note:</strong> QR scan functionality will be available once staff members are added and permissions are configured.</p>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
</body>
</html>

