-- Real Upcoming Events for beLIVE EventsHUB
-- Clear existing events first
SET FOREIGN_KEY_CHECKS = 0;
DELETE FROM ticket_types;
DELETE FROM bookings;
DELETE FROM tickets;
DELETE FROM reviews;
DELETE FROM events;
SET FOREIGN_KEY_CHECKS = 1;

-- Get organizer and user IDs
SET @organizer1 = (SELECT id FROM organizers LIMIT 1);
SET @organizer2 = (SELECT id FROM organizers ORDER BY id LIMIT 1 OFFSET 1);
SET @venue_user1 = (SELECT user_id FROM venues LIMIT 1);
SET @venue_user1 = IFNULL(@venue_user1, (SELECT id FROM customers WHERE email LIKE '%venue%' LIMIT 1));
SET @venue_user1 = IFNULL(@venue_user1, (SELECT id FROM customers LIMIT 1));

-- Create or get venues (use INSERT IGNORE to avoid duplicates)
INSERT IGNORE INTO venues (user_id, venue_name, address, city, country, capacity, verification_status, is_active, created_at)
VALUES
(@venue_user1, 'World Trade Centre', 'Sheikh Zayed Road', 'Dubai', 'UAE', 5000, 'verified', 1, NOW()),
(@venue_user1, 'Coca Cola Arena', 'City Walk', 'Dubai', 'UAE', 17000, 'verified', 1, NOW()),
(@venue_user1, 'Etihad Arena', 'Yas Island', 'Abu Dhabi', 'UAE', 18000, 'verified', 1, NOW()),
(@venue_user1, 'Zabeel Park', 'Zabeel Area', 'Dubai', 'UAE', 10000, 'verified', 1, NOW()),
(@venue_user1, 'Dubai Cricket Stadium', 'Sports City', 'Dubai', 'UAE', 25000, 'verified', 1, NOW());

INSERT INTO venues (user_id, venue_name, address, city, country, capacity, verification_status, is_active, created_at)
SELECT @organizer1, 'Coca Cola Arena', 'City Walk', 'Dubai', 'UAE', 17000, 'verified', 1, NOW()
WHERE NOT EXISTS (SELECT 1 FROM venues WHERE venue_name = 'Coca Cola Arena' AND city = 'Dubai')
LIMIT 1;

INSERT INTO venues (user_id, venue_name, address, city, country, capacity, verification_status, is_active, created_at)
SELECT @organizer1, 'Etihad Arena', 'Yas Island', 'Abu Dhabi', 'UAE', 18000, 'verified', 1, NOW()
WHERE NOT EXISTS (SELECT 1 FROM venues WHERE venue_name = 'Etihad Arena' AND city = 'Abu Dhabi')
LIMIT 1;

INSERT INTO venues (user_id, venue_name, address, city, country, capacity, verification_status, is_active, created_at)
SELECT @organizer1, 'Zabeel Park', 'Zabeel Area', 'Dubai', 'UAE', 10000, 'verified', 1, NOW()
WHERE NOT EXISTS (SELECT 1 FROM venues WHERE venue_name = 'Zabeel Park' AND city = 'Dubai')
LIMIT 1;

INSERT INTO venues (user_id, venue_name, address, city, country, capacity, verification_status, is_active, created_at)
SELECT @organizer1, 'Dubai Cricket Stadium', 'Sports City', 'Dubai', 'UAE', 25000, 'verified', 1, NOW()
WHERE NOT EXISTS (SELECT 1 FROM venues WHERE venue_name = 'Dubai Cricket Stadium' AND city = 'Dubai')
LIMIT 1;

-- Get venue IDs
SET @wtc_dubai = (SELECT id FROM venues WHERE venue_name = 'World Trade Centre' AND city = 'Dubai' LIMIT 1);
SET @cca_dubai = (SELECT id FROM venues WHERE venue_name = 'Coca Cola Arena' AND city = 'Dubai' LIMIT 1);
SET @etihad_ad = (SELECT id FROM venues WHERE venue_name = 'Etihad Arena' AND city = 'Abu Dhabi' LIMIT 1);
SET @zabeel_dubai = (SELECT id FROM venues WHERE venue_name = 'Zabeel Park' AND city = 'Dubai' LIMIT 1);
SET @cricket_dubai = (SELECT id FROM venues WHERE venue_name = 'Dubai Cricket Stadium' AND city = 'Dubai' LIMIT 1);

-- Insert Real Events (assuming 2025 for dates without year)
INSERT INTO events (organizer_id, venue_id, name, description, short_description, event_type, category, start_date, end_date, city, country, address, banner_image, attendees_range, pricing, ticket_available, status, is_featured, language, genre, created_at) VALUES

-- March 2025
(@organizer1, @wtc_dubai, 'Lucky Ali Live', 'Experience the legendary voice of Lucky Ali in an unforgettable live performance. Join us for an evening of soulful melodies and timeless hits.', 'Lucky Ali Live Concert', 'concert', 'Concerts', '2025-03-21 20:00:00', '2025-03-21 23:00:00', 'Dubai', 'UAE', 'Sheikh Zayed Road', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '5000+', 'From AED 200', 1, 'approved', 1, 'Hindi, English', 'Bollywood', NOW()),

-- April 2025
(@organizer1, @wtc_dubai, 'Aditya Gadhvi Live', 'Enjoy an evening with the soulful voice of Aditya Gadhvi. Experience Gujarati folk music and contemporary melodies.', 'Aditya Gadhvi Concert', 'concert', 'Concerts', '2025-04-18 20:00:00', '2025-04-18 23:00:00', 'Dubai', 'UAE', 'Sheikh Zayed Road', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '5000+', 'From AED 180', 1, 'approved', 0, 'Gujarati, Hindi', 'Folk', NOW()),

(@organizer1, @etihad_ad, 'Rahat Fateh Ali Khan Live', 'Witness the mesmerizing performance of Ustad Rahat Fateh Ali Khan. An evening of classical and contemporary qawwali.', 'Rahat Fateh Ali Khan Concert', 'concert', 'Concerts', '2025-04-25 20:00:00', '2025-04-25 23:30:00', 'Abu Dhabi', 'UAE', 'Yas Island', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '18000+', 'From AED 250', 1, 'approved', 1, 'Urdu, Hindi', 'Qawwali', NOW()),

(@organizer1, @cca_dubai, 'Vishal Mishra Live', 'Join us for an intimate evening with Vishal Mishra. Experience his soulful compositions and heartfelt performances.', 'Vishal Mishra Concert', 'concert', 'Concerts', '2025-04-26 20:00:00', '2025-04-26 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 220', 1, 'approved', 0, 'Hindi', 'Bollywood', NOW()),

-- May 2025
(@organizer1, @cca_dubai, 'SEL with Farhan Akhtar', 'An electrifying evening with Farhan Akhtar and his band. Rock music meets Bollywood in this spectacular show.', 'Farhan Akhtar Live', 'concert', 'Concerts', '2025-05-15 20:00:00', '2025-05-15 23:30:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '17000+', 'From AED 300', 1, 'approved', 1, 'Hindi, English', 'Rock', NOW()),

(@organizer1, @wtc_dubai, 'Jaya Kishori Live', 'Spiritual evening with Jaya Kishori. Experience devotional music and inspirational discourse.', 'Jaya Kishori Satsang', 'concert', 'Concerts', '2025-05-23 18:00:00', '2025-05-23 21:00:00', 'Dubai', 'UAE', 'Sheikh Zayed Road', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '5000+', 'From AED 150', 1, 'approved', 0, 'Hindi', 'Devotional', NOW()),

-- August 2025
(@organizer1, @cca_dubai, 'Armaan & Amaal Malik Live', 'Brothers Armaan and Amaal Malik come together for an unforgettable musical evening. Hit songs and live performances.', 'Armaan & Amaal Malik Concert', 'concert', 'Concerts', '2025-08-29 20:00:00', '2025-08-29 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 250', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

-- September 2025
(@organizer1, @cca_dubai, 'South Indian Music Movement', 'A celebration of South Indian music featuring top artists from Tamil, Telugu, Malayalam, and Kannada cinema.', 'South Indian Music Festival', 'festival', 'Festivals', '2025-09-19 19:00:00', '2025-09-19 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '17000+', 'From AED 280', 1, 'approved', 1, 'Tamil, Telugu, Malayalam, Kannada', 'South Indian', NOW()),

(@organizer1, @cca_dubai, 'Bollywood Music Project', 'The biggest Bollywood music festival featuring multiple artists and hit songs from the golden era to today.', 'Bollywood Music Festival', 'festival', 'Festivals', '2025-09-20 19:00:00', '2025-09-20 23:30:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '17000+', 'From AED 300', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

-- October 2025
(@organizer1, @zabeel_dubai, 'Falguni Pathak Live', 'Dandiya Queen Falguni Pathak brings her energetic performance to Dubai. Join the celebration of Navratri with live music.', 'Falguni Pathak Dandiya Night', 'festival', 'Festivals', '2025-10-24 19:00:00', '2025-10-24 23:00:00', 'Dubai', 'UAE', 'Zabeel Area', 'https://images.unsplash.com/photo-1514525253161-7a46d19cd819?w=1200', '10000+', 'From AED 200', 1, 'approved', 1, 'Gujarati, Hindi', 'Dandiya', NOW()),

(@organizer1, @cca_dubai, 'Nancy Ajram Live', 'Lebanese superstar Nancy Ajram performs live in Dubai. An evening of Arabic pop and Middle Eastern music.', 'Nancy Ajram Concert', 'concert', 'Concerts', '2025-10-24 20:00:00', '2025-10-24 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 250', 1, 'approved', 1, 'Arabic', 'Arabic Pop', NOW()),

(@organizer1, @cca_dubai, 'Shreya Ghoshal Live', 'Experience the melodious voice of Shreya Ghoshal in a spectacular live performance. An evening of timeless Bollywood hits.', 'Shreya Ghoshal Concert', 'concert', 'Concerts', '2025-10-25 20:00:00', '2025-10-25 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 350', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

-- November 2025
(@organizer1, @etihad_ad, 'Atif Aslam Live', 'Pakistani sensation Atif Aslam performs live in Abu Dhabi. Experience his soulful voice and hit songs.', 'Atif Aslam Concert', 'concert', 'Concerts', '2025-11-20 20:00:00', '2025-11-20 23:30:00', 'Abu Dhabi', 'UAE', 'Yas Island', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '18000+', 'From AED 300', 1, 'approved', 1, 'Urdu, Hindi', 'Pop', NOW()),

-- December 2025
(@organizer1, @cca_dubai, 'Badshah Live', 'Hip-hop superstar Badshah brings his high-energy performance to Dubai. An electrifying night of rap and hip-hop.', 'Badshah Concert', 'concert', 'Concerts', '2025-12-04 20:00:00', '2025-12-04 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 280', 1, 'approved', 1, 'Hindi, Punjabi', 'Hip-Hop', NOW()),

-- January 2026
(@organizer1, @cca_dubai, 'Rahat Fateh Ali Khan & Abida Parveen', 'Two legendary voices come together. Ustad Rahat Fateh Ali Khan and Abida Parveen in a once-in-a-lifetime performance.', 'Rahat & Abida Live', 'concert', 'Concerts', '2026-01-08 20:00:00', '2026-01-08 23:30:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 400', 1, 'approved', 1, 'Urdu, Hindi', 'Classical', NOW()),

(@organizer1, @cca_dubai, 'Subhash Ghai Musical', 'Bollywood maestro Subhash Ghai presents a musical extravaganza featuring songs from his iconic films.', 'Subhash Ghai Musical Show', 'concert', 'Concerts', '2026-01-22 20:00:00', '2026-01-22 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '17000+', 'From AED 300', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

(@organizer1, @wtc_dubai, 'Sonu Nigam Live', 'The voice of a generation, Sonu Nigam performs live in Dubai. An evening of timeless Bollywood classics.', 'Sonu Nigam Concert', 'concert', 'Concerts', '2026-01-30 20:00:00', '2026-01-30 23:30:00', 'Dubai', 'UAE', 'Sheikh Zayed Road', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '5000+', 'From AED 350', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

(@organizer1, @cca_dubai, 'Prateek Kuhad Live', 'Indie sensation Prateek Kuhad brings his intimate acoustic performance to Dubai. An evening of soulful melodies.', 'Prateek Kuhad Concert', 'concert', 'Concerts', '2026-01-31 20:00:00', '2026-01-31 23:00:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 200', 1, 'approved', 0, 'Hindi, English', 'Indie', NOW()),

-- February 2026
(@organizer1, @cricket_dubai, 'Arijit Singh Live', 'The king of Bollywood playback, Arijit Singh performs live at Dubai Cricket Stadium. The biggest concert of the year.', 'Arijit Singh Concert', 'concert', 'Concerts', '2026-02-06 19:00:00', '2026-02-06 23:30:00', 'Dubai', 'UAE', 'Sports City', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '25000+', 'From AED 400', 1, 'approved', 1, 'Hindi', 'Bollywood', NOW()),

-- March 2026
(@organizer1, @cca_dubai, 'AR Rahman Live', 'Oscar winner AR Rahman brings his spectacular live show to Dubai. An evening of music that transcends boundaries.', 'AR Rahman Concert', 'concert', 'Concerts', '2026-03-14 20:00:00', '2026-03-14 23:30:00', 'Dubai', 'UAE', 'City Walk', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '17000+', 'From AED 500', 1, 'approved', 1, 'Hindi, Tamil, English', 'World Music', NOW());

-- Create ticket types for some featured events
SET @lucky_ali = (SELECT id FROM events WHERE name = 'Lucky Ali Live' LIMIT 1);
SET @rahat_april = (SELECT id FROM events WHERE name = 'Rahat Fateh Ali Khan Live' AND start_date = '2025-04-25 20:00:00' LIMIT 1);
SET @farhan = (SELECT id FROM events WHERE name = 'SEL with Farhan Akhtar' LIMIT 1);
SET @arijit = (SELECT id FROM events WHERE name = 'Arijit Singh Live' LIMIT 1);
SET @ar_rahman = (SELECT id FROM events WHERE name = 'AR Rahman Live' LIMIT 1);

INSERT INTO ticket_types (event_id, name, description, type, price, quantity, available, min_purchase, max_purchase, is_active) VALUES
(@lucky_ali, 'General Admission', 'General seating', 'regular', 200.00, 3000, 3000, 1, 8, 1),
(@lucky_ali, 'VIP', 'VIP seating with premium view', 'vip', 500.00, 500, 500, 1, 4, 1),
(@rahat_april, 'General Admission', 'General seating', 'regular', 250.00, 10000, 10000, 1, 10, 1),
(@rahat_april, 'Premium', 'Premium seating', 'vip', 600.00, 3000, 3000, 1, 6, 1),
(@farhan, 'General Admission', 'General seating', 'regular', 300.00, 10000, 10000, 1, 10, 1),
(@farhan, 'VIP', 'VIP access', 'vip', 800.00, 2000, 2000, 1, 4, 1),
(@arijit, 'General Admission', 'General seating', 'regular', 400.00, 15000, 15000, 1, 10, 1),
(@arijit, 'Premium', 'Premium seating', 'vip', 1000.00, 5000, 5000, 1, 6, 1),
(@ar_rahman, 'General Admission', 'General seating', 'regular', 500.00, 10000, 10000, 1, 10, 1),
(@ar_rahman, 'VIP', 'VIP seating with meet & greet', 'vip', 1500.00, 2000, 2000, 1, 4, 1);

