<?php
/**
 * Organizer - Settings
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireOrganizer();

// Check permission to view settings
requirePermission('organizer.settings.view', 'You do not have permission to view settings.');

$organizer = getCurrentOrganizer();
$user = getCurrentUser();
$pdo = getDB();

$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings | Organizer Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="organizer-panel">
    <?php 
    $current_page = 'settings';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Settings</h1>
                
                <!-- Organizer Profile -->
                <div class="section">
                    <h2>Organizer Profile</h2>
                    <form method="POST" action="<?php echo $baseUrl; ?>/api/organizer/updateprofileapi.php">
                        <div class="form-group">
                            <label for="company_name">Company Name *</label>
                            <input type="text" id="company_name" name="company_name" value="<?php echo htmlspecialchars($organizer['company_name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea id="description" name="description" rows="4"><?php echo htmlspecialchars($organizer['description'] ?? ''); ?></textarea>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                            <div class="form-group">
                                <label for="contact_email">Contact Email *</label>
                                <input type="email" id="contact_email" name="contact_email" value="<?php echo htmlspecialchars($organizer['contact_email'] ?? $user['email']); ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="tel" id="contact_phone" name="contact_phone" value="<?php echo htmlspecialchars($organizer['contact_phone'] ?? ''); ?>">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="website">Website</label>
                            <input type="url" id="website" name="website" value="<?php echo htmlspecialchars($organizer['website'] ?? ''); ?>" placeholder="https://example.com">
                        </div>
                        
                        <div class="form-group">
                            <label for="address">Address</label>
                            <textarea id="address" name="address" rows="2"><?php echo htmlspecialchars($organizer['address'] ?? ''); ?></textarea>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1rem;">
                            <div class="form-group">
                                <label for="city">City</label>
                                <input type="text" id="city" name="city" value="<?php echo htmlspecialchars($organizer['city'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="state">State</label>
                                <input type="text" id="state" name="state" value="<?php echo htmlspecialchars($organizer['state'] ?? ''); ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="country">Country</label>
                                <input type="text" id="country" name="country" value="<?php echo htmlspecialchars($organizer['country'] ?? ''); ?>">
                            </div>
                        </div>
                        
                        <button type="submit" class="btn-sm btn-primary">Update Profile</button>
                    </form>
                </div>
                
                <!-- KYC Status -->
                <div class="section">
                    <h2>Verification Status</h2>
                    <p>
                        <strong>KYC Status:</strong> 
                        <span class="status-badge status-<?php echo $organizer['kyc_status']; ?>">
                            <?php echo ucfirst($organizer['kyc_status']); ?>
                        </span>
                    </p>
                    <?php if ($organizer['kyc_status'] !== 'verified'): ?>
                        <p style="color: #6b7280; margin-top: 0.5rem;">
                            Your organizer account is pending verification. Please contact support to complete KYC verification.
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
    
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
</body>
</html>

