<?php
/**
 * Organizer - Create Artist
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireOrganizer();

// Check permission to create artists
if (!hasPermission('organizer.artists.create')) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/organizer/dashboard.php?error=' . urlencode('You do not have permission to create artists.'));
    exit;
}

$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Artist | Organizer Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="organizer-panel">
    <?php 
    $current_page = 'artists';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Create New Artist</h1>
                
                <div class="section">
                    <form id="createArtistForm" method="POST" action="<?php echo $baseUrl; ?>/api/organizer/artistsapi.php">
                        <div class="form-group">
                            <label for="name">Artist Name *</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="bio">Bio / Description</label>
                            <textarea id="bio" name="bio" rows="6" placeholder="Tell us about this artist..."></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="profile_image">Profile Image URL</label>
                            <input type="url" id="profile_image" name="profile_image" placeholder="https://example.com/image.jpg">
                            <small class="form-text">Enter a URL to the artist's profile image</small>
                        </div>
                        
                        <div class="form-group">
                            <label>Social Links (Optional)</label>
                            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-top: 0.5rem;">
                                <div>
                                    <label for="social_website" style="font-size: 0.875rem; color: #6b7280;">Website URL</label>
                                    <input type="url" id="social_website" name="social_links[website]" placeholder="https://example.com">
                                </div>
                                <div>
                                    <label for="social_facebook" style="font-size: 0.875rem; color: #6b7280;">Facebook URL</label>
                                    <input type="url" id="social_facebook" name="social_links[facebook]" placeholder="https://facebook.com/...">
                                </div>
                                <div>
                                    <label for="social_twitter" style="font-size: 0.875rem; color: #6b7280;">Twitter/X URL</label>
                                    <input type="url" id="social_twitter" name="social_links[twitter]" placeholder="https://twitter.com/...">
                                </div>
                                <div>
                                    <label for="social_instagram" style="font-size: 0.875rem; color: #6b7280;">Instagram URL</label>
                                    <input type="url" id="social_instagram" name="social_links[instagram]" placeholder="https://instagram.com/...">
                                </div>
                                <div>
                                    <label for="social_youtube" style="font-size: 0.875rem; color: #6b7280;">YouTube URL</label>
                                    <input type="url" id="social_youtube" name="social_links[youtube]" placeholder="https://youtube.com/...">
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select id="status" name="status">
                                <option value="unpublished" selected>Unpublished</option>
                                <option value="published">Published</option>
                            </select>
                            <small class="form-text">Unpublished artists are not visible to the public</small>
                        </div>
                        
                        <button type="submit" class="btn-sm btn-primary">Create Artist</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo $baseUrl; ?>';
    </script>
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
    <script>
    document.getElementById('createArtistForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const data = {};
        
        // Collect form data
        for (let [key, value] of formData.entries()) {
            if (key.startsWith('social_links[')) {
                const socialKey = key.match(/\[(.*?)\]/)[1];
                if (!data.social_links) data.social_links = {};
                if (value.trim()) {
                    data.social_links[socialKey] = value.trim();
                }
            } else {
                if (value.trim()) {
                    data[key] = value.trim();
                }
            }
        }
        
        // Remove status from create (defaults to unpublished)
        delete data.status;
        
        try {
            const response = await fetch(this.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                credentials: 'same-origin',
                body: JSON.stringify(data)
            });
            
            const result = await response.json();
            
            if (!result.success) {
                throw new Error(result.message || 'Failed to create artist');
            }
            
            alert('Artist created successfully');
            window.location.href = BASE_URL + '/organizer/pages/artists.php';
            
        } catch (error) {
            console.error('Error creating artist:', error);
            alert('Error: ' + error.message);
        }
    });
    </script>
</body>
</html>
