<?php
/**
 * Organizer Panel - Dashboard
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/roles.php';

// Check if already logged in as organizer
if (isOrganizer()) {
    header('Location: ' . BASE_URL . '/organizer/dashboard.php');
    exit;
}

// Redirect to login if not logged in
if (!isLoggedIn()) {
    header('Location: ' . BASE_URL . '/organizer/login.php?error=' . urlencode('Please login first'));
    exit;
}

// Check if user has organizer role
$organizer = isOrganizer();
if (!$organizer) {
    header('Location: ' . BASE_URL . '/login.html?error=' . urlencode('You need to register as an organizer'));
    exit;
}

header('Location: ' . BASE_URL . '/organizer/dashboard.php');
exit;

