<?php
if (!function_exists('getCorrectBaseUrl')) {
    require_once __DIR__ . '/../../includes/url_helper.php';
}
require_once __DIR__ . '/../../includes/permissions.php';
$baseUrl = getCorrectBaseUrl();
?>
<nav class="admin-sidebar">
    <ul class="admin-menu">
        <li><a href="<?php echo $baseUrl; ?>/organizer/dashboard.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'dashboard') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><rect x="2" y="2" width="5" height="5" rx="0.5"/><rect x="9" y="2" width="5" height="5" rx="0.5"/><rect x="2" y="9" width="5" height="5" rx="0.5"/><rect x="9" y="9" width="5" height="5" rx="0.5"/></svg></span> Dashboard
        </a></li>
        <?php if (hasPermission('organizer.events.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/events.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'events') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><rect x="3" y="4" width="10" height="10" rx="1"/><path d="M3 6h10M6 3v3M10 3v3"/></svg></span> My Events
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.artists.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/artists.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'artists') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="8" cy="6" r="3"/><path d="M3 14c0-2.5 2-4.5 5-4.5s5 2 5 4.5"/></svg></span> My Artists
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.agendas.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/agendas.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'agendas') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><rect x="3" y="3" width="10" height="10" rx="2"/><path d="M5 6h6M5 9h4M5 12h3"/></svg></span> My Agendas
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.sponsors.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/sponsors.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'sponsors') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><rect x="3" y="3" width="10" height="10" rx="2"/><path d="M6 7h4M6 10h2"/></svg></span> My Sponsors
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.promotions.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/promotions.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'promotions') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="8" cy="8" r="6"/><path d="M8 4v4l3 2"/></svg></span> Promotions
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.sales.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/sales.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'sales') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><path d="M3 12l3-4 3 2 4-6" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 12h12" stroke-linecap="round"/></svg></span> Sales & Finance
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.attendees.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/attendees.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'attendees') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="8" cy="5" r="2"/><path d="M3 14c0-2.5 2-4.5 5-4.5s5 2 5 4.5"/></svg></span> Attendees
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.refunds.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/refunds.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'refunds') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><path d="M8 2v12M2 8h12" stroke-linecap="round"/><path d="M8 2l6 6-6 6M8 2L2 8l6 6"/></svg></span> Refunds
        </a></li>
        <?php endif; ?>
        <?php if (hasPermission('organizer.settings.view')): ?>
        <li><a href="<?php echo $baseUrl; ?>/organizer/pages/settings.php" class="menu-item <?php echo (isset($current_page) && $current_page === 'settings') ? 'active' : ''; ?>">
            <span class="menu-icon"><svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="8" cy="8" r="2"/><path d="M8 1v2M8 13v2M15 8h-2M3 8H1M13.5 2.5l-1.4 1.4M3.9 12.1l-1.4 1.4M13.5 13.5l-1.4-1.4M3.9 3.9l-1.4-1.4"/></svg></span> Settings
        </a></li>
        <?php endif; ?>
    </ul>
</nav>

