<?php
if (!isset($user)) {
    $user = getCurrentUser();
}
if (!isset($organizer)) {
    $organizer = getCurrentOrganizer();
}
require_once __DIR__ . '/../../includes/url_helper.php';
$baseUrl = getCorrectBaseUrl();
?>
<header class="admin-header">
    <div class="admin-header-content">
        <div class="admin-logo">
            <a href="<?php echo $baseUrl; ?>/organizer/dashboard.php">
                <img src="https://events.videostech.cloud/_next/image?url=%2Fbelive-logo.png&w=1920&q=75" alt="beLIVE" style="height: 40px;">
            </a>
        </div>
        <div class="admin-header-right">
            <div class="admin-user-menu">
                <span class="admin-user-name"><?php echo htmlspecialchars($organizer['company_name'] ?? $user['full_name'] ?? $user['email']); ?></span>
                <div class="admin-user-dropdown">
                    <a href="<?php echo $baseUrl; ?>/profile.html">Profile</a>
                    <a href="<?php echo $baseUrl; ?>/api/auth/logout.php">Logout</a>
                </div>
            </div>
        </div>
    </div>
</header>

