<?php
/**
 * Organizer Dashboard
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/roles.php';
require_once __DIR__ . '/../includes/permissions.php';
require_once __DIR__ . '/../includes/url_helper.php';

requireOrganizer();

// Dashboard gate: user must have at least one organizer permission
if (!hasAnyPermission([
    'organizer.events.view',
    'organizer.events.create',
    'organizer.events.edit',
    'organizer.events.delete',
    'organizer.attendees.view',
    'organizer.sales.view',
    'organizer.promotions.view',
    'organizer.refunds.view',
    'organizer.settings.view',
], $_SESSION['user_id'] ?? null)) {
    $baseUrl = getCorrectBaseUrl();
    header('Location: ' . $baseUrl . '/organizer/login.php?error=' . urlencode('No organizer permissions assigned. Please contact your administrator.'));
    exit;
}

$organizer = getCurrentOrganizer();
$user = getCurrentUser();
$organizerName = $organizer['company_name'] ?? $user['full_name'] ?? $user['email'] ?? 'Organizer';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Organizer Dashboard | beLIVE EventsHUB</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <?php 
    $baseUrl = getCorrectBaseUrl();
    // getCorrectBaseUrl() already returns full URL, no need for fallback
    ?>
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <style>
        /* Dashboard Header - Matching Image Style */
        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 2rem;
            flex-wrap: wrap;
            gap: 1rem;
        }
        .dashboard-header-left h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: #111827;
            margin-bottom: 0.5rem;
            font-family: 'Inter', sans-serif;
        }
        .dashboard-header-left p {
            font-size: 0.9375rem;
            color: #6b7280;
            margin: 0;
            font-family: 'Inter', sans-serif;
        }
        .dashboard-header-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        .export-btn {
            padding: 0.625rem 1.25rem;
            background: #dc2626;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 0.875rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            font-family: 'Inter', sans-serif;
        }
        .export-btn:hover {
            background: #b91c1c;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(220, 38, 38, 0.3);
        }
        
        /* Summary Cards - Matching Image Style */
        .summary-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        .summary-card {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            transition: all 0.2s;
            cursor: pointer;
            border: 1px solid #f3f4f6;
            display: flex;
            justify-content: space-between;
        }
        .summary-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.12);
            border-color: #fee2e2;
        }
        .summary-card-content h3 {
            font-size: 0.8125rem;
            font-weight: 500;
            color: #6b7280;
            margin-bottom: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-family: 'Inter', sans-serif;
        }
        .summary-card-content .value {
            font-size: 2rem;
            font-weight: 700;
            color: #111827;
            margin-bottom: 0.5rem;
            font-family: 'Inter', sans-serif;
        }
        .summary-card-content .change {
            font-size: 0.75rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.25rem;
            font-family: 'Inter', sans-serif;
        }
        .summary-card-content .change.positive {
            color: #10b981;
        }
        .summary-card-content .change.negative {
            color: #ef4444;
        }
        .summary-card-content .link {
            font-size: 0.8125rem;
            color: #dc2626;
            text-decoration: none;
            font-weight: 500;
            margin-top: 0.5rem;
            display: inline-block;
            font-family: 'Inter', sans-serif;
        }
        .summary-card-content .link:hover {
            text-decoration: underline;
        }
         .summary-card-icon {
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 12px;
            font-size: 1.75rem;
            flex-shrink: 0;
        }
        .summary-card-icon.blue { background: #dbeafe; }
        .summary-card-icon.green { background: #d1fae5; }
        .summary-card-icon.yellow { background: #fef3c7; }
        .summary-card-icon.red { background: #fee2e2; }
        
        /* Charts Section - Matching Image Style */
        .charts-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        .chart-container {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            border: 1px solid #f3f4f6;
        }
        .chart-container h3 {
            font-size: 1.125rem;
            font-weight: 600;
            color: #111827;
            margin-bottom: 1.5rem;
            font-family: 'Inter', sans-serif;
        }
        .chart-wrapper {
            position: relative;
            height: 300px;
        }
        
        /* Tabs Section - Matching Image Style with Red Colors */
        .tabs-section {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            margin-bottom: 2rem;
            border: 1px solid #f3f4f6;
        }
        .tabs-section h3 {
            font-size: 1.125rem;
            font-weight: 600;
            color: #111827;
            margin-bottom: 1.25rem;
            font-family: 'Inter', sans-serif;
        }
        .tabs {
            display: flex;
            gap: 0.5rem;
            flex-wrap: wrap;
        }
        .tab {
            padding: 0.625rem 1.25rem;
            background: #f9fafb;
            color: #4b5563;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            font-size: 0.875rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
            font-family: 'Inter', sans-serif;
        }
        .tab:hover {
            background: #fee2e2;
            color: #dc2626;
            border-color: #fecaca;
            transform: translateY(-1px);
        }
        .tab.active {
            background: #dc2626;
            color: white;
            border-color: #dc2626;
            box-shadow: 0 2px 4px rgba(220, 38, 38, 0.2);
        }
        
        /* Body Background - Clean White */
        body.organizer-panel {
            background: #ffffff;
        }
        .admin-main {
            background: #ffffff;
        }
        
        @media (max-width: 968px) {
            .charts-section {
                grid-template-columns: 1fr;
            }
            .summary-cards {
                grid-template-columns: 1fr;
            }
            .dashboard-header {
                flex-direction: column;
            }
        }
    </style>
</head>
<body class="organizer-panel">
    <?php 
    $current_page = 'dashboard';
    include __DIR__ . '/includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <!-- Dashboard Header - Matching Image Style -->
                <div class="dashboard-header">
                    <div class="dashboard-header-left">
                        <h1>Welcome Back, <?php echo htmlspecialchars(explode(' ', $organizerName)[0]); ?></h1>
                        <p>Let's dive in and get things done.</p>
                    </div>
                    <div class="dashboard-header-right">
                        <button class="export-btn" onclick="exportDashboard()">Export report</button>
                    </div>
                </div>
                
                
                <!-- Charts Section - Matching Image Style -->
                <div class="charts-section">
                    <div class="chart-container">
                        <h3>Event Performance Over Time</h3>
                        <div class="chart-wrapper">
                            <canvas id="performanceChart"></canvas>
                        </div>
                    </div>
                    <div class="chart-container">
                        <h3>Event Status Distribution</h3>
                        <div class="chart-wrapper">
                            <canvas id="statusChart"></canvas>
                        </div>
                    </div>
                </div>

                 <!-- Summary Cards - Matching Image Style -->
                <div class="summary-cards" id="summaryCards">
                    <div class="summary-card" onclick="window.location.href='<?php echo $baseUrl; ?>/organizer/pages/events.php'">
                        <div class="summary-card-content">
                            <h3>Total Events</h3>
                            <div class="value" id="totalEvents">0</div>
                            <div class="change positive">
                                <span>↑</span>
                                <span id="totalEventsChange">0%</span>
                            </div>
                            <a href="<?php echo $baseUrl; ?>/organizer/pages/events.php" class="link">View all events</a>
                        </div>
                        <div class="summary-card-icon blue">📅</div>
                    </div>
                    <div class="summary-card" onclick="window.location.href='<?php echo $baseUrl; ?>/organizer/pages/events.php?status=published'">
                        <div class="summary-card-content">
                            <h3>Published Events</h3>
                            <div class="value" id="publishedEvents">0</div>
                            <div class="change positive">
                                <span>↑</span>
                                <span id="publishedEventsChange">0%</span>
                            </div>
                            <a href="<?php echo $baseUrl; ?>/organizer/pages/events.php?status=published" class="link">View published events</a>
                        </div>
                        <div class="summary-card-icon green">✅</div>
                    </div>
                    <div class="summary-card" onclick="window.location.href='<?php echo $baseUrl; ?>/organizer/pages/events.php?status=draft'">
                        <div class="summary-card-content">
                            <h3>Draft Events</h3>
                            <div class="value" id="draftEvents">0</div>
                            <div class="change positive">
                                <span>↑</span>
                                <span id="draftEventsChange">0%</span>
                            </div>
                            <a href="<?php echo $baseUrl; ?>/organizer/pages/events.php?status=draft" class="link">View draft events</a>
                        </div>
                        <div class="summary-card-icon yellow">📝</div>
                    </div>
                    <div class="summary-card" onclick="window.location.href='<?php echo $baseUrl; ?>/organizer/pages/events.php?status=cancelled'">
                        <div class="summary-card-content">
                            <h3>Cancelled Events</h3>
                            <div class="value" id="cancelledEvents">0</div>
                            <div class="change negative">
                                <span>↓</span>
                                <span id="cancelledEventsChange">0%</span>
                            </div>
                            <a href="<?php echo $baseUrl; ?>/organizer/pages/events.php?status=cancelled" class="link">View cancelled events</a>
                        </div>
                        <div class="summary-card-icon red">❌</div>
                    </div>
                </div>
                
                <!-- Quick Access Tabs - Matching Image Style with Red Colors -->
                <div class="tabs-section">
                    <h3>Quick Access</h3>
                    <div class="tabs">
                        <a href="<?php echo $baseUrl; ?>/organizer/pages/events.php" class="tab" id="tab-events">
                            All Events (<span id="tabEventsCount">0</span>)
                        </a>
                        <a href="<?php echo $baseUrl; ?>/organizer/pages/artists.php" class="tab" id="tab-artists">
                            All Artists (<span id="tabArtistsCount">0</span>)
                        </a>
                        <a href="<?php echo $baseUrl; ?>/organizer/pages/sponsors.php" class="tab" id="tab-sponsors">
                            All Sponsors (<span id="tabSponsorsCount">0</span>)
                        </a>
                        <a href="<?php echo $baseUrl; ?>/organizer/pages/agendas.php" class="tab" id="tab-agendas">
                            All Agendas (<span id="tabAgendasCount">0</span>)
                        </a>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo $baseUrl; ?>';
        
        // Export dashboard function
        function exportDashboard() {
            alert('Export functionality will be implemented soon.');
        }
        
        // Set active tab based on current URL (if on dashboard)
        document.addEventListener('DOMContentLoaded', function() {
            // Tabs are clickable links, no need for active state management on dashboard
            // Active state will be handled by the destination pages
        });
    </script>
    <script src="<?php echo $baseUrl; ?>/admin/assets/js/admin.js"></script>
    <script src="<?php echo $baseUrl; ?>/organizer/assets/js/organizer-api.js"></script>
    <script src="<?php echo $baseUrl; ?>/organizer/assets/js/organizer-dashboard.js"></script>
</body>
</html>
