-- Sponsors Module Migration
-- Creates sponsors table and event_sponsors pivot table for many-to-many relationship

-- Sponsors Table
CREATE TABLE IF NOT EXISTS `sponsors` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `organizer_id` INT(11) NOT NULL COMMENT 'Owner of the sponsor',
  `name` VARCHAR(255) NOT NULL,
  `description` TEXT DEFAULT NULL COMMENT 'Sponsor description',
  `logo_image` VARCHAR(500) DEFAULT NULL,
  `website_url` VARCHAR(500) DEFAULT NULL,
  `status` ENUM('published', 'unpublished') DEFAULT 'unpublished',
  `is_active` TINYINT(1) DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` TIMESTAMP NULL DEFAULT NULL COMMENT 'Soft delete timestamp',
  PRIMARY KEY (`id`),
  KEY `organizer_id` (`organizer_id`),
  KEY `status` (`status`),
  KEY `is_active` (`is_active`),
  KEY `deleted_at` (`deleted_at`),
  FOREIGN KEY (`organizer_id`) REFERENCES `organizers`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Event Sponsors Pivot Table (Many-to-Many)
CREATE TABLE IF NOT EXISTS `event_sponsors` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `event_id` INT(11) NOT NULL,
  `sponsor_id` INT(11) NOT NULL,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `event_sponsor` (`event_id`, `sponsor_id`),
  KEY `event_id` (`event_id`),
  KEY `sponsor_id` (`sponsor_id`),
  FOREIGN KEY (`event_id`) REFERENCES `events`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`sponsor_id`) REFERENCES `sponsors`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add Sponsor Permissions
INSERT INTO `permissions` (`name`, `slug`, `module`, `description`, `is_active`) VALUES
('View My Sponsors', 'organizer.sponsors.view', 'organizer_sponsors', 'View own sponsors', 1),
('Create Sponsors', 'organizer.sponsors.create', 'organizer_sponsors', 'Create new sponsors', 1),
('Edit My Sponsors', 'organizer.sponsors.edit', 'organizer_sponsors', 'Edit own sponsors', 1),
('Delete My Sponsors', 'organizer.sponsors.delete', 'organizer_sponsors', 'Delete own sponsors', 1),
('Publish Sponsors', 'organizer.sponsors.publish', 'organizer_sponsors', 'Publish/unpublish own sponsors', 1)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- Assign sponsor permissions to organizer_manager role
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT r.id, p.id
FROM `roles` r
CROSS JOIN `permissions` p
WHERE r.slug = 'organizer_manager'
AND p.slug IN (
    'organizer.sponsors.view',
    'organizer.sponsors.create',
    'organizer.sponsors.edit',
    'organizer.sponsors.delete',
    'organizer.sponsors.publish'
)
ON DUPLICATE KEY UPDATE `role_id` = VALUES(`role_id`);