-- Artist Module Migration
-- Creates artists table and event_artists pivot table for many-to-many relationship

-- Artists Table
CREATE TABLE IF NOT EXISTS `artists` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `organizer_id` INT(11) NOT NULL COMMENT 'Owner of the artist',
  `name` VARCHAR(255) NOT NULL,
  `bio` TEXT DEFAULT NULL COMMENT 'Bio / description',
  `profile_image` VARCHAR(500) DEFAULT NULL,
  `social_links` JSON DEFAULT NULL COMMENT 'Social media links (optional)',
  `status` ENUM('published', 'unpublished') DEFAULT 'unpublished',
  `is_active` TINYINT(1) DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` TIMESTAMP NULL DEFAULT NULL COMMENT 'Soft delete timestamp',
  PRIMARY KEY (`id`),
  KEY `organizer_id` (`organizer_id`),
  KEY `status` (`status`),
  KEY `is_active` (`is_active`),
  KEY `deleted_at` (`deleted_at`),
  FOREIGN KEY (`organizer_id`) REFERENCES `organizers`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Event Artists Pivot Table (Many-to-Many)
CREATE TABLE IF NOT EXISTS `event_artists` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `event_id` INT(11) NOT NULL,
  `artist_id` INT(11) NOT NULL,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `event_artist` (`event_id`, `artist_id`),
  KEY `event_id` (`event_id`),
  KEY `artist_id` (`artist_id`),
  FOREIGN KEY (`event_id`) REFERENCES `events`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`artist_id`) REFERENCES `artists`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add Artist Permissions
INSERT INTO `permissions` (`name`, `slug`, `module`, `description`, `is_active`) VALUES
('View My Artists', 'organizer.artists.view', 'organizer_artists', 'View own artists', 1),
('Create Artists', 'organizer.artists.create', 'organizer_artists', 'Create new artists', 1),
('Edit My Artists', 'organizer.artists.edit', 'organizer_artists', 'Edit own artists', 1),
('Delete My Artists', 'organizer.artists.delete', 'organizer_artists', 'Delete own artists', 1),
('Publish Artists', 'organizer.artists.publish', 'organizer_artists', 'Publish/unpublish own artists', 1)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- Assign artist permissions to organizer_manager role
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT r.id, p.id
FROM `roles` r
CROSS JOIN `permissions` p
WHERE r.slug = 'organizer_manager'
AND p.slug IN (
    'organizer.artists.view',
    'organizer.artists.create',
    'organizer.artists.edit',
    'organizer.artists.delete',
    'organizer.artists.publish'
)
ON DUPLICATE KEY UPDATE `role_id` = VALUES(`role_id`);

