-- Agendas Module Migration
-- Creates agendas table and event_agendas pivot table for many-to-many relationship with events

-- Agendas Table
CREATE TABLE IF NOT EXISTS `agendas` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `organizer_id` INT(11) NOT NULL COMMENT 'Owner of the agenda',
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT DEFAULT NULL COMMENT 'Agenda description / details',
  `start_time` DATETIME DEFAULT NULL COMMENT 'Agenda start time',
  `end_time` DATETIME DEFAULT NULL COMMENT 'Agenda end time',
  `status` ENUM('published', 'unpublished') DEFAULT 'unpublished',
  `is_active` TINYINT(1) DEFAULT 1,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` TIMESTAMP NULL DEFAULT NULL COMMENT 'Soft delete timestamp',
  PRIMARY KEY (`id`),
  KEY `organizer_id` (`organizer_id`),
  KEY `status` (`status`),
  KEY `is_active` (`is_active`),
  KEY `deleted_at` (`deleted_at`),
  KEY `start_time` (`start_time`),
  KEY `end_time` (`end_time`),
  FOREIGN KEY (`organizer_id`) REFERENCES `organizers`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Event Agendas Pivot Table (Many-to-Many)
CREATE TABLE IF NOT EXISTS `event_agendas` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `event_id` INT(11) NOT NULL,
  `agenda_id` INT(11) NOT NULL,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `event_agenda` (`event_id`, `agenda_id`),
  KEY `event_id` (`event_id`),
  KEY `agenda_id` (`agenda_id`),
  FOREIGN KEY (`event_id`) REFERENCES `events`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`agenda_id`) REFERENCES `agendas`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add Agenda Permissions
INSERT INTO `permissions` (`name`, `slug`, `module`, `description`, `is_active`) VALUES
('View My Agendas', 'organizer.agendas.view', 'organizer_agendas', 'View own agendas', 1),
('Create Agendas', 'organizer.agendas.create', 'organizer_agendas', 'Create new agendas', 1),
('Edit My Agendas', 'organizer.agendas.edit', 'organizer_agendas', 'Edit own agendas', 1),
('Delete My Agendas', 'organizer.agendas.delete', 'organizer_agendas', 'Delete own agendas', 1),
('Publish Agendas', 'organizer.agendas.publish', 'organizer_agendas', 'Publish/unpublish own agendas', 1)
ON DUPLICATE KEY UPDATE `name` = VALUES(`name`);

-- Assign agenda permissions to organizer_manager role
INSERT INTO `role_permissions` (`role_id`, `permission_id`)
SELECT r.id, p.id
FROM `roles` r
CROSS JOIN `permissions` p
WHERE r.slug = 'organizer_manager'
AND p.slug IN (
    'organizer.agendas.view',
    'organizer.agendas.create',
    'organizer.agendas.edit',
    'organizer.agendas.delete',
    'organizer.agendas.publish'
)
ON DUPLICATE KEY UPDATE `role_id` = VALUES(`role_id`);


