<?php
/**
 * URL Helper Functions
 */

/**
 * Get correct base URL - Always uses BASE_URL constant from config.php
 * This ensures consistent URL generation across the entire application
 */
function getCorrectBaseUrl() {
    // Always use BASE_URL constant if defined (from config.php)
    // This ensures single source of truth for base URL
    if (defined('BASE_URL')) {
        return BASE_URL;
    }
    
    // Fallback: Build from current request (should rarely be needed)
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    
    // Production domain detection
    if (strpos($host, 'belive-events.videostech.cloud') !== false) {
        return $protocol . '://' . $host; // No subfolder for production
    }
    
    // Alternative production domain
    if (strpos($host, 'recognizer.multitvsolution.com') !== false || strpos($host, 'multitvsolution.com') !== false) {
        return $protocol . '://' . $host . '/events';
    }
    
    // Local development fallback
    return $protocol . '://' . $host . '/events_belive';
}

