<?php
/**
 * API Helper Functions
 */

/**
 * Send JSON response
 */
function sendJSONResponse($data, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

/**
 * Send success response
 */
function sendSuccess($data = [], $message = 'Success') {
    sendJSONResponse([
        'success' => true,
        'message' => $message,
        'data' => $data
    ]);
}

/**
 * Send error response
 */
function sendError($message = 'Error', $statusCode = 400, $errors = []) {
    sendJSONResponse([
        'success' => false,
        'message' => $message,
        'errors' => $errors
    ], $statusCode);
}

/**
 * Validate required fields
 */
function validateRequired($data, $requiredFields) {
    $errors = [];
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || empty($data[$field])) {
            $errors[] = "Field '{$field}' is required";
        }
    }
    return $errors;
}

/**
 * Sanitize input
 */
function sanitizeInput($data) {
    if (is_array($data)) {
        return array_map('sanitizeInput', $data);
    }
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

/**
 * Get request data (POST/GET/JSON)
 */
function getRequestData() {
    $data = [];
    
    // Get JSON input
    $json = file_get_contents('php://input');
    if (!empty($json)) {
        $data = json_decode($json, true) ?? [];
    }
    
    // Merge with POST data
    if (!empty($_POST)) {
        $data = array_merge($data, $_POST);
    }
    
    // Merge with GET data (for query parameters)
    if (!empty($_GET)) {
        $data = array_merge($data, $_GET);
    }
    
    return sanitizeInput($data);
}

