-- Dummy Events for All Categories
-- This file adds events for each category type

-- Get organizer and venue IDs
SET @organizer1 = (SELECT id FROM organizers WHERE company_name = 'Global Events Inc' LIMIT 1);
SET @organizer2 = (SELECT id FROM organizers WHERE company_name = 'Tech Events Co' LIMIT 1);
SET @venue1 = (SELECT id FROM venues WHERE venue_name = 'Grand Convention Center' LIMIT 1);
SET @venue2 = (SELECT id FROM venues WHERE venue_name = 'Metro Exhibition Hall' LIMIT 1);

-- CONferences
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Global Tech Conference 2025', 'Join industry leaders and innovators for three days of cutting-edge technology discussions, networking opportunities, and exclusive product launches. Features keynote speakers from Fortune 500 companies.', 'Premier technology conference', 'conference', 'Conferences', '2025-08-15 09:00:00', '2025-08-17 18:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1505373877841-8d25f7d46678?w=1200', '3000+', 'From $399', 1, 'approved', 1, NOW()),
(@organizer2, @venue2, 'Digital Marketing Summit', 'Learn the latest strategies in digital marketing, SEO, social media, and content creation from industry experts. Perfect for marketers and business owners.', 'Digital marketing strategies', 'conference', 'Conferences', '2025-09-10 08:00:00', '2025-09-11 17:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=1200', '1500+', 'From $249', 1, 'approved', 0, NOW()),
(@organizer1, NULL, 'Remote Work Conference', 'Explore the future of remote work, distributed teams, and digital collaboration tools. Network with remote work advocates and learn best practices.', 'Future of remote work', 'conference', 'Conferences', '2025-10-05 10:00:00', '2025-10-06 16:00:00', 'Online', NULL, 'Global', 'Virtual Event', 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=1200', 'Unlimited', 'From $99', 1, 'approved', 0, NOW());

-- EXHIBITIONS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer2, @venue2, 'International Trade Exhibition', 'Discover innovative products and services from leading manufacturers and suppliers. Network with industry professionals and explore business opportunities.', 'International trade showcase', 'exhibition', 'Exhibitions', '2025-07-25 10:00:00', '2025-07-27 18:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1540575467063-178a55c36af4?w=1200', '5000+', 'From $149', 1, 'approved', 1, NOW()),
(@organizer1, @venue1, 'Art & Design Expo', 'Experience the finest in contemporary art, design, and creative expression. Meet artists, view installations, and purchase unique pieces.', 'Contemporary art exhibition', 'exhibition', 'Exhibitions', '2025-11-15 11:00:00', '2025-11-17 19:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1513475382585-d06e58bcb0e0?w=1200', '2000+', 'From $79', 1, 'approved', 0, NOW()),
(@organizer2, @venue2, 'Automotive Showcase', 'See the latest vehicles, technologies, and innovations in the automotive industry. Test drives and interactive displays available.', 'Automotive industry showcase', 'exhibition', 'Exhibitions', '2025-12-05 09:00:00', '2025-12-08 18:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1492144534655-ae79c964c9d7?w=1200', '8000+', 'From $199', 1, 'approved', 0, NOW());

-- SUMMITS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Leadership Summit 2025', 'Join C-level executives and business leaders for strategic discussions on leadership, innovation, and organizational transformation.', 'Executive leadership summit', 'summit', 'Summits', '2025-09-20 08:00:00', '2025-09-22 17:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1552664730-d307ca884978?w=1200', '2000+', 'From $599', 1, 'approved', 1, NOW()),
(@organizer2, @venue2, 'Climate Action Summit', 'Addressing climate change through innovation, policy, and collaboration. Join environmental leaders and sustainability experts.', 'Climate and sustainability', 'summit', 'Summits', '2025-10-25 09:00:00', '2025-10-26 18:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1470071459604-3b5ec3a7fe05?w=1200', '1500+', 'From $299', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Healthcare Innovation Summit', 'Exploring the future of healthcare through technology, research, and patient care innovations. Network with healthcare professionals.', 'Healthcare technology summit', 'summit', 'Summits', '2025-11-10 08:00:00', '2025-11-12 17:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1576091160399-112ba8d25d1f?w=1200', '2500+', 'From $449', 1, 'approved', 0, NOW());

-- FESTIVALS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Summer Music Festival', 'Three days of amazing music featuring top artists from around the world. Food vendors, art installations, and unforgettable experiences await.', 'Music festival with top artists', 'festival', 'Festivals', '2025-07-04 14:00:00', '2025-07-06 23:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '10000+', 'From $79', 1, 'approved', 1, NOW()),
(@organizer2, @venue2, 'Food & Wine Festival', 'Indulge in culinary delights from renowned chefs and sample wines from around the world. Cooking demonstrations and tastings included.', 'Culinary and wine experience', 'festival', 'Festivals', '2025-08-20 12:00:00', '2025-08-22 22:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1556910103-1c02745aae4d?w=1200', '5000+', 'From $129', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Cultural Heritage Festival', 'Celebrate diverse cultures through music, dance, food, and art. Experience traditions from around the globe in one amazing event.', 'Multicultural celebration', 'festival', 'Festivals', '2025-09-15 10:00:00', '2025-09-17 20:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1514525253161-7a46d19cd819?w=1200', '8000+', 'From $59', 1, 'approved', 0, NOW());

-- TRADE SHOWS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer2, @venue2, 'Electronics Trade Show', 'Discover the latest electronics, gadgets, and tech innovations. Meet manufacturers, distributors, and industry professionals.', 'Electronics industry trade show', 'trade-show', 'Trade Shows', '2025-08-10 09:00:00', '2025-08-12 18:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1518770660439-4636190af475?w=1200', '6000+', 'From $179', 1, 'approved', 1, NOW()),
(@organizer1, @venue1, 'Fashion Trade Show', 'Explore the latest fashion trends, meet designers, and discover new brands. B2B networking and retail opportunities.', 'Fashion industry showcase', 'trade-show', 'Trade Shows', '2025-10-12 10:00:00', '2025-10-14 18:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1441986300917-64674bd600d8?w=1200', '4000+', 'From $199', 1, 'approved', 0, NOW()),
(@organizer2, @venue2, 'Construction & Building Expo', 'See the latest in construction materials, tools, and technologies. Network with contractors, architects, and suppliers.', 'Construction industry expo', 'trade-show', 'Trade Shows', '2025-11-20 08:00:00', '2025-11-22 17:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=1200', '5000+', 'From $149', 1, 'approved', 0, NOW());

-- CONCERTS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Rock Legends Concert', 'Experience an unforgettable night with legendary rock artists performing their greatest hits. Special guest appearances included.', 'Legendary rock concert', 'concert', 'Concerts', '2025-08-30 19:00:00', '2025-08-30 23:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '5000+', 'From $89', 1, 'approved', 1, NOW()),
(@organizer2, @venue2, 'Jazz Night Live', 'Enjoy an evening of smooth jazz with world-renowned musicians. Intimate setting with premium acoustics.', 'Intimate jazz performance', 'concert', 'Concerts', '2025-09-25 20:00:00', '2025-09-25 23:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=1200', '2000+', 'From $69', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Pop Music Extravaganza', 'The biggest pop music event of the year featuring chart-topping artists and electrifying performances.', 'Pop music concert', 'concert', 'Concerts', '2025-10-15 18:00:00', '2025-10-15 23:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '8000+', 'From $99', 1, 'approved', 0, NOW());

-- SPORTS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Basketball Championship Finals', 'Witness the ultimate showdown as top teams compete for the championship title. High-energy action and unforgettable moments.', 'Championship basketball finals', 'sports', 'Sports', '2025-09-05 18:00:00', '2025-09-05 22:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1546519638-68e109498ffc?w=1200', '10000+', 'From $149', 1, 'approved', 1, NOW()),
(@organizer2, @venue2, 'Marathon & Running Festival', 'Join thousands of runners in this annual marathon event. Multiple race categories and distances available for all skill levels.', 'Annual marathon event', 'sports', 'Sports', '2025-10-20 06:00:00', '2025-10-20 14:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1571008887538-b36bb32f4571?w=1200', '5000+', 'From $49', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Tennis Grand Slam', 'Watch world-class tennis players compete in this prestigious tournament. Multiple matches throughout the day.', 'Professional tennis tournament', 'sports', 'Sports', '2025-11-08 10:00:00', '2025-11-10 20:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1534158914592-062992fbe900?w=1200', '6000+', 'From $79', 1, 'approved', 0, NOW());

-- WORKSHOPS
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer2, @venue2, 'Photography Masterclass', 'Learn advanced photography techniques from professional photographers. Hands-on sessions and portfolio reviews included.', 'Professional photography workshop', 'workshop', 'Workshops', '2025-08-15 09:00:00', '2025-08-15 17:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=1200', '100', 'From $149', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Web Development Bootcamp', 'Intensive one-day bootcamp covering modern web development technologies. Perfect for beginners and intermediate developers.', 'Web development intensive', 'workshop', 'Workshops', '2025-09-12 09:00:00', '2025-09-12 18:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=1200', '200', 'From $199', 1, 'approved', 0, NOW()),
(@organizer2, @venue2, 'Creative Writing Workshop', 'Unlock your creative potential with expert guidance on storytelling, character development, and narrative techniques.', 'Creative writing intensive', 'workshop', 'Workshops', '2025-10-18 10:00:00', '2025-10-18 16:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1455390582262-044cdead277a?w=1200', '50', 'From $99', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Data Science Workshop', 'Learn data analysis, machine learning basics, and visualization techniques. Hands-on projects and real-world applications.', 'Data science fundamentals', 'workshop', 'Workshops', '2025-11-22 09:00:00', '2025-11-22 17:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=1200', '150', 'From $249', 1, 'approved', 0, NOW());

-- Get event IDs for ticket types
SET @conf_event1 = (SELECT id FROM events WHERE name = 'Global Tech Conference 2025' LIMIT 1);
SET @conf_event2 = (SELECT id FROM events WHERE name = 'Digital Marketing Summit' LIMIT 1);
SET @exh_event1 = (SELECT id FROM events WHERE name = 'International Trade Exhibition' LIMIT 1);
SET @summit_event1 = (SELECT id FROM events WHERE name = 'Leadership Summit 2025' LIMIT 1);
SET @festival_event1 = (SELECT id FROM events WHERE name = 'Summer Music Festival' LIMIT 1);
SET @tradeshow_event1 = (SELECT id FROM events WHERE name = 'Electronics Trade Show' LIMIT 1);
SET @concert_event1 = (SELECT id FROM events WHERE name = 'Rock Legends Concert' LIMIT 1);
SET @sports_event1 = (SELECT id FROM events WHERE name = 'Basketball Championship Finals' LIMIT 1);
SET @workshop_event1 = (SELECT id FROM events WHERE name = 'Photography Masterclass' LIMIT 1);

-- Insert ticket types for some events
INSERT INTO `ticket_types` (`event_id`, `name`, `description`, `type`, `price`, `quantity`, `available`, `min_purchase`, `max_purchase`, `is_active`) VALUES
-- Conference tickets
(@conf_event1, 'Early Bird', 'Early bird pricing', 'early_bird', 299.00, 500, 500, 1, 5, 1),
(@conf_event1, 'Regular', 'Standard ticket', 'regular', 399.00, 2000, 2000, 1, 10, 1),
(@conf_event1, 'VIP', 'VIP access', 'vip', 799.00, 200, 200, 1, 3, 1),
-- Exhibition tickets
(@exh_event1, 'Day Pass', 'Single day access', 'regular', 149.00, 2000, 2000, 1, 5, 1),
(@exh_event1, 'Full Pass', 'All days access', 'regular', 249.00, 1000, 1000, 1, 5, 1),
-- Summit tickets
(@summit_event1, 'Standard', 'Standard access', 'regular', 599.00, 1500, 1500, 1, 5, 1),
(@summit_event1, 'Premium', 'Premium access with networking dinner', 'vip', 999.00, 300, 300, 1, 3, 1),
-- Festival tickets
(@festival_event1, 'General Admission', 'General festival access', 'regular', 79.00, 5000, 5000, 1, 10, 1),
(@festival_event1, 'VIP', 'VIP access with premium viewing', 'vip', 199.00, 500, 500, 1, 5, 1),
-- Trade Show tickets
(@tradeshow_event1, 'Business Pass', 'Business day access', 'regular', 179.00, 3000, 3000, 1, 10, 1),
(@tradeshow_event1, 'Exhibitor Pass', 'Exhibitor access', 'custom', 0.00, 500, 500, 1, 1, 1),
-- Concert tickets
(@concert_event1, 'General Admission', 'General seating', 'regular', 89.00, 3000, 3000, 1, 8, 1),
(@concert_event1, 'Premium Seating', 'Premium seats', 'vip', 199.00, 1000, 1000, 1, 4, 1),
(@concert_event1, 'Backstage Pass', 'Backstage access', 'vip', 399.00, 100, 100, 1, 2, 1),
-- Sports tickets
(@sports_event1, 'Upper Level', 'Upper level seating', 'regular', 149.00, 5000, 5000, 1, 10, 1),
(@sports_event1, 'Lower Level', 'Lower level seating', 'regular', 249.00, 3000, 3000, 1, 8, 1),
(@sports_event1, 'VIP Box', 'VIP box seats', 'vip', 599.00, 200, 200, 1, 4, 1),
-- Workshop tickets
(@workshop_event1, 'Standard', 'Workshop access with materials', 'regular', 149.00, 80, 80, 1, 2, 1),
(@workshop_event1, 'Student', 'Student discount', 'custom', 99.00, 20, 20, 1, 1, 1);

