-- Dummy Data for beLIVE EventsHUB
-- This file inserts sample data for testing purposes

-- Insert Categories (if not exists)
INSERT IGNORE INTO `categories` (`name`, `slug`, `description`, `is_active`) VALUES
('Conferences', 'conferences', 'Professional conferences and business events', 1),
('Exhibitions', 'exhibitions', 'Trade shows and exhibitions', 1),
('Festivals', 'festivals', 'Cultural and music festivals', 1),
('Concerts', 'concerts', 'Live music concerts', 1),
('Sports', 'sports', 'Sports events and tournaments', 1),
('Workshops', 'workshops', 'Educational workshops and seminars', 1),
('Summits', 'summits', 'Business and technology summits', 1),
('Trade Shows', 'trade-shows', 'Industry trade shows', 1);

-- Insert Sample Customers (if not exists)
INSERT IGNORE INTO `customers` (`email`, `first_name`, `last_name`, `full_name`, `phone`, `is_active`, `email_verified`, `created_at`) VALUES
('john.doe@example.com', 'John', 'Doe', 'John Doe', '+1234567890', 1, 1, NOW()),
('jane.smith@example.com', 'Jane', 'Smith', 'Jane Smith', '+1234567891', 1, 1, NOW()),
('mike.johnson@example.com', 'Mike', 'Johnson', 'Mike Johnson', '+1234567892', 1, 1, NOW()),
('sarah.williams@example.com', 'Sarah', 'Williams', 'Sarah Williams', '+1234567893', 1, 1, NOW()),
('david.brown@example.com', 'David', 'Brown', 'David Brown', '+1234567894', 1, 1, NOW()),
('organizer1@example.com', 'Event', 'Organizer', 'Event Organizer One', '+1234567895', 1, 1, NOW()),
('organizer2@example.com', 'Tech', 'Events', 'Tech Events Co', '+1234567896', 1, 1, NOW()),
('venue1@example.com', 'Venue', 'Manager', 'Venue Manager One', '+1234567897', 1, 1, NOW()),
('venue2@example.com', 'Hall', 'Owner', 'Hall Owner', '+1234567898', 1, 1, NOW());

SET @customer1 = (SELECT id FROM customers WHERE email = 'john.doe@example.com');
SET @customer2 = (SELECT id FROM customers WHERE email = 'jane.smith@example.com');
SET @customer3 = (SELECT id FROM customers WHERE email = 'mike.johnson@example.com');
SET @organizer_user1 = (SELECT id FROM customers WHERE email = 'organizer1@example.com');
SET @organizer_user2 = (SELECT id FROM customers WHERE email = 'organizer2@example.com');
SET @venue_user1 = (SELECT id FROM customers WHERE email = 'venue1@example.com');
SET @venue_user2 = (SELECT id FROM customers WHERE email = 'venue2@example.com');

-- Insert Organizers
INSERT INTO `organizers` (`user_id`, `company_name`, `description`, `contact_email`, `contact_phone`, `address`, `city`, `state`, `country`, `kyc_status`, `is_active`) VALUES
(@organizer_user1, 'Global Events Inc', 'Leading event management company specializing in tech conferences and business summits', 'organizer1@example.com', '+1234567895', '123 Business St', 'New York', 'NY', 'USA', 'verified', 1),
(@organizer_user2, 'Tech Events Co', 'Premier technology event organizer hosting conferences and workshops worldwide', 'organizer2@example.com', '+1234567896', '456 Tech Avenue', 'San Francisco', 'CA', 'USA', 'verified', 1);

SET @organizer1 = (SELECT id FROM organizers WHERE user_id = @organizer_user1);
SET @organizer2 = (SELECT id FROM organizers WHERE user_id = @organizer_user2);

-- Insert Venues
INSERT INTO `venues` (`user_id`, `venue_name`, `description`, `contact_email`, `contact_phone`, `address`, `city`, `state`, `country`, `capacity`, `verification_status`, `is_active`) VALUES
(@venue_user1, 'Grand Convention Center', 'State-of-the-art convention center with multiple halls and modern amenities', 'venue1@example.com', '+1234567897', '789 Convention Blvd', 'Las Vegas', 'NV', 'USA', 5000, 'verified', 1),
(@venue_user2, 'Metro Exhibition Hall', 'Spacious exhibition hall perfect for trade shows and large events', 'venue2@example.com', '+1234567898', '321 Exhibition Road', 'Chicago', 'IL', 'USA', 3000, 'verified', 1);

SET @venue1 = (SELECT id FROM venues WHERE user_id = @venue_user1);
SET @venue2 = (SELECT id FROM venues WHERE user_id = @venue_user2);

-- Insert Events
INSERT INTO `events` (`organizer_id`, `venue_id`, `name`, `description`, `short_description`, `event_type`, `category`, `start_date`, `end_date`, `city`, `state`, `country`, `address`, `banner_image`, `attendees_range`, `pricing`, `ticket_available`, `status`, `is_featured`, `created_at`) VALUES
(@organizer1, @venue1, 'Tech Summit 2025', 'Join us for the biggest technology summit of the year featuring keynote speakers from leading tech companies, panel discussions, networking opportunities, and exclusive product launches.', 'Premier technology conference', 'summit', 'Summits', '2025-06-15 09:00:00', '2025-06-17 18:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1505373877841-8d25f7d46678?w=1200', '5000+', 'From $299', 1, 'approved', 1, NOW()),
(@organizer1, @venue1, 'Business Innovation Conference', 'Explore the latest trends in business innovation, digital transformation, and entrepreneurship. Connect with industry leaders and discover new opportunities.', 'Business innovation and entrepreneurship', 'conference', 'Conferences', '2025-07-20 08:00:00', '2025-07-22 17:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1540575467063-178a55c36af4?w=1200', '3000+', 'From $199', 1, 'live', 1, NOW()),
(@organizer2, @venue2, 'Digital Marketing Expo', 'Comprehensive exhibition showcasing the latest tools, strategies, and technologies in digital marketing. Meet vendors, attend workshops, and gain insights.', 'Digital marketing tools and strategies', 'exhibition', 'Exhibitions', '2025-08-10 10:00:00', '2025-08-12 18:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=1200', '2000+', 'From $149', 1, 'approved', 0, NOW()),
(@organizer2, @venue2, 'AI & Machine Learning Workshop', 'Hands-on workshop covering artificial intelligence and machine learning fundamentals. Perfect for developers and data scientists.', 'AI and ML fundamentals', 'workshop', 'Workshops', '2025-05-25 09:00:00', '2025-05-25 17:00:00', 'Chicago', 'IL', 'USA', '321 Exhibition Road', 'https://images.unsplash.com/photo-1485827404703-89b55fcc595e?w=1200', '500', 'From $99', 1, 'approved', 0, NOW()),
(@organizer1, @venue1, 'Summer Music Festival', 'Three days of amazing music featuring top artists from around the world. Food vendors, art installations, and unforgettable experiences await.', 'Music festival with top artists', 'festival', 'Festivals', '2025-07-04 14:00:00', '2025-07-06 23:00:00', 'Las Vegas', 'NV', 'USA', '789 Convention Blvd', 'https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=1200', '10000+', 'From $79', 1, 'pending', 0, NOW()),
(@organizer2, NULL, 'Virtual Tech Conference', 'Join us online for a virtual technology conference featuring live sessions, Q&A, and networking opportunities from the comfort of your home.', 'Online technology conference', 'conference', 'Conferences', '2025-09-15 10:00:00', '2025-09-16 18:00:00', 'Online', NULL, 'Global', 'Virtual Event', 'https://images.unsplash.com/photo-1551434678-e076c223a692?w=1200', 'Unlimited', 'Free', 1, 'approved', 0, NOW());

SET @event1 = (SELECT id FROM events WHERE name = 'Tech Summit 2025');
SET @event2 = (SELECT id FROM events WHERE name = 'Business Innovation Conference');
SET @event3 = (SELECT id FROM events WHERE name = 'Digital Marketing Expo');
SET @event4 = (SELECT id FROM events WHERE name = 'AI & Machine Learning Workshop');
SET @event5 = (SELECT id FROM events WHERE name = 'Summer Music Festival');
SET @event6 = (SELECT id FROM events WHERE name = 'Virtual Tech Conference');

-- Insert Ticket Types
INSERT INTO `ticket_types` (`event_id`, `name`, `description`, `type`, `price`, `quantity`, `available`, `min_purchase`, `max_purchase`, `valid_from`, `valid_until`, `is_active`) VALUES
-- Tech Summit 2025
(@event1, 'Early Bird', 'Early bird pricing - limited availability', 'early_bird', 299.00, 500, 450, 1, 5, NOW(), '2025-05-15 23:59:59', 1),
(@event1, 'Regular', 'Standard conference ticket', 'regular', 399.00, 2000, 1850, 1, 10, NOW(), '2025-06-14 23:59:59', 1),
(@event1, 'VIP', 'VIP access with premium seating and networking dinner', 'vip', 799.00, 200, 175, 1, 3, NOW(), '2025-06-14 23:59:59', 1),
(@event1, 'Group Pass', 'Group discount for 5+ tickets', 'group', 299.00, 1000, 950, 5, 20, NOW(), '2025-06-14 23:59:59', 1),

-- Business Innovation Conference
(@event2, 'Standard', 'Standard conference access', 'regular', 199.00, 1500, 1420, 1, 10, NOW(), '2025-07-19 23:59:59', 1),
(@event2, 'Premium', 'Premium access with lunch included', 'custom', 299.00, 500, 480, 1, 5, NOW(), '2025-07-19 23:59:59', 1),

-- Digital Marketing Expo
(@event3, 'Day Pass', 'Single day access', 'regular', 149.00, 1000, 950, 1, 5, NOW(), '2025-08-09 23:59:59', 1),
(@event3, 'Full Pass', 'Full event access for all days', 'regular', 249.00, 500, 475, 1, 5, NOW(), '2025-08-09 23:59:59', 1),

-- AI & Machine Learning Workshop
(@event4, 'Standard', 'Workshop access with materials', 'regular', 99.00, 200, 180, 1, 3, NOW(), '2025-05-24 23:59:59', 1),
(@event4, 'Student', 'Student discount ticket', 'custom', 49.00, 100, 95, 1, 2, NOW(), '2025-05-24 23:59:59', 1),

-- Virtual Tech Conference
(@event6, 'Free Access', 'Free virtual conference access', 'complimentary', 0.00, 9999, 9999, 1, 1, NOW(), '2025-09-14 23:59:59', 1);

-- Insert Wallets
INSERT INTO `wallets` (`customer_id`, `balance`, `currency`) VALUES
(@customer1, 500.00, 'USD'),
(@customer2, 250.00, 'USD'),
(@customer3, 1000.00, 'USD'),
(@organizer_user1, 0.00, 'USD'),
(@organizer_user2, 0.00, 'USD');

-- Insert Loyalty Points
INSERT INTO `loyalty_points` (`customer_id`, `points`, `tier`) VALUES
(@customer1, 1500, 'gold'),
(@customer2, 500, 'regular'),
(@customer3, 2500, 'premium');

-- Insert Memberships
INSERT INTO `memberships` (`customer_id`, `tier`, `status`, `start_date`, `end_date`, `auto_renew`) VALUES
(@customer1, 'gold', 'active', '2025-01-01', '2025-12-31', 1),
(@customer3, 'premium', 'active', '2025-01-01', '2025-12-31', 1);

-- Insert Sample Bookings
INSERT INTO `bookings` (`booking_reference`, `customer_id`, `event_id`, `total_amount`, `discount_amount`, `final_amount`, `payment_status`, `payment_method`, `status`, `booking_date`) VALUES
('BK2025001', @customer1, @event1, 399.00, 0.00, 399.00, 'completed', 'credit_card', 'confirmed', NOW() - INTERVAL 5 DAY),
('BK2025002', @customer2, @event2, 199.00, 20.00, 179.00, 'completed', 'wallet', 'confirmed', NOW() - INTERVAL 3 DAY),
('BK2025003', @customer3, @event1, 799.00, 0.00, 799.00, 'completed', 'credit_card', 'confirmed', NOW() - INTERVAL 2 DAY),
('BK2025004', @customer1, @event3, 249.00, 0.00, 249.00, 'pending', 'credit_card', 'pending', NOW() - INTERVAL 1 DAY),
('BK2025005', @customer2, @event4, 99.00, 0.00, 99.00, 'completed', 'credit_card', 'confirmed', NOW());

SET @booking1 = (SELECT id FROM bookings WHERE booking_reference = 'BK2025001');
SET @booking2 = (SELECT id FROM bookings WHERE booking_reference = 'BK2025002');
SET @booking3 = (SELECT id FROM bookings WHERE booking_reference = 'BK2025003');
SET @booking4 = (SELECT id FROM bookings WHERE booking_reference = 'BK2025004');
SET @booking5 = (SELECT id FROM bookings WHERE booking_reference = 'BK2025005');

SET @ticket_type1 = (SELECT id FROM ticket_types WHERE event_id = @event1 AND type = 'regular' LIMIT 1);
SET @ticket_type2 = (SELECT id FROM ticket_types WHERE event_id = @event2 AND type = 'regular' LIMIT 1);
SET @ticket_type3 = (SELECT id FROM ticket_types WHERE event_id = @event1 AND type = 'vip' LIMIT 1);
SET @ticket_type4 = (SELECT id FROM ticket_types WHERE event_id = @event3 AND type = 'regular' LIMIT 1);
SET @ticket_type5 = (SELECT id FROM ticket_types WHERE event_id = @event4 AND type = 'regular' LIMIT 1);

-- Insert Tickets
INSERT INTO `tickets` (`booking_id`, `ticket_type_id`, `ticket_number`, `customer_name`, `customer_email`, `price`, `status`) VALUES
(@booking1, @ticket_type1, 'TKT-2025-001-001', 'John Doe', 'john.doe@example.com', 399.00, 'confirmed'),
(@booking2, @ticket_type2, 'TKT-2025-002-001', 'Jane Smith', 'jane.smith@example.com', 199.00, 'confirmed'),
(@booking3, @ticket_type3, 'TKT-2025-003-001', 'Mike Johnson', 'mike.johnson@example.com', 799.00, 'confirmed'),
(@booking4, @ticket_type4, 'TKT-2025-004-001', 'John Doe', 'john.doe@example.com', 249.00, 'pending'),
(@booking5, @ticket_type5, 'TKT-2025-005-001', 'Jane Smith', 'jane.smith@example.com', 99.00, 'confirmed');

-- Insert Reviews
INSERT INTO `reviews` (`event_id`, `customer_id`, `rating`, `review_text`, `is_verified`, `is_approved`) VALUES
(@event1, @customer1, 5, 'Amazing event! Great speakers and excellent networking opportunities. Highly recommend!', 1, 1),
(@event2, @customer2, 4, 'Very informative conference with valuable insights. The venue was great too.', 1, 1),
(@event1, @customer3, 5, 'Best tech summit I have attended. Well organized and fantastic content.', 1, 1),
(@event4, @customer2, 4, 'Great workshop! Learned a lot about AI and ML. The instructor was excellent.', 1, 1);

-- Insert Coupons
INSERT INTO `coupons` (`code`, `name`, `description`, `discount_type`, `discount_value`, `min_purchase`, `usage_limit`, `valid_from`, `valid_until`, `applicable_to`, `is_active`) VALUES
('EARLY2025', 'Early Bird 2025', 'Get 20% off on early bird tickets', 'percentage', 20.00, 100.00, 100, NOW(), '2025-12-31 23:59:59', 'all', 1),
('STUDENT10', 'Student Discount', '10% off for students', 'percentage', 10.00, 50.00, 500, NOW(), '2025-12-31 23:59:59', 'all', 1),
('SAVE50', 'Save $50', 'Flat $50 discount on purchases over $200', 'fixed', 50.00, 200.00, 200, NOW(), '2025-12-31 23:59:59', 'all', 1);

-- Insert CMS Content
INSERT INTO `cms_content` (`page_slug`, `page_title`, `content`, `meta_title`, `meta_description`, `is_active`) VALUES
('about-us', 'About beLIVE EventsHUB', '<h2>Welcome to beLIVE EventsHUB</h2><p>beLIVE EventsHUB is a unified event management platform designed to bridge the gap between event organizers and attendees. We provide a seamless experience for discovering, managing, and attending events worldwide.</p><p>Our platform empowers small to medium-scale event organizers with powerful tools to digitize ticket sales, manage events, and grow their audience.</p><h3>Our Mission</h3><p>To simplify event discovery and ticket purchasing while empowering organizers with self-service event management tools.</p><h3>Key Features</h3><ul><li>AI-driven event recommendations</li><li>Secure ticketing ecosystem</li><li>Wallet and loyalty programs</li><li>Comprehensive event management tools</li><li>Real-time analytics and reporting</li></ul>', 'About Us - beLIVE EventsHUB', 'Learn about beLIVE EventsHUB, a modern event listing and management platform.', 1),
('privacy-policy', 'Privacy Policy', '<h2>Privacy Policy</h2><p>Your privacy is important to us. This policy explains how we collect, use, and protect your personal information.</p>', 'Privacy Policy - beLIVE EventsHUB', 'Privacy policy for beLIVE EventsHUB', 1),
('terms-of-service', 'Terms of Service', '<h2>Terms of Service</h2><p>By using our platform, you agree to these terms and conditions.</p>', 'Terms of Service - beLIVE EventsHUB', 'Terms of service for beLIVE EventsHUB', 1);

-- Insert Banners
INSERT INTO `banners` (`title`, `image_url`, `link_url`, `position`, `order`, `is_active`, `start_date`, `end_date`) VALUES
('Tech Summit 2025', 'https://images.unsplash.com/photo-1505373877841-8d25f7d46678?w=1200', CONCAT('/event-detail.html?id=', @event1), 'homepage', 1, 1, NOW(), '2025-06-15 23:59:59'),
('Business Innovation Conference', 'https://images.unsplash.com/photo-1540575467063-178a55c36af4?w=1200', CONCAT('/event-detail.html?id=', @event2), 'homepage', 2, 1, NOW(), '2025-07-22 23:59:59'),
('Digital Marketing Expo', 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=1200', CONCAT('/event-detail.html?id=', @event3), 'homepage', 3, 1, NOW(), '2025-08-12 23:59:59');

-- Insert Notifications
INSERT INTO `notifications` (`user_id`, `user_type`, `type`, `title`, `message`, `link`, `is_read`) VALUES
(@customer1, 'customer', 'booking_confirmed', 'Booking Confirmed', 'Your booking for Tech Summit 2025 has been confirmed!', '/profile.html', 0),
(@customer2, 'customer', 'event_reminder', 'Event Reminder', 'Business Innovation Conference starts in 3 days!', CONCAT('/event-detail.html?id=', @event2), 0),
(@organizer_user1, 'organizer', 'event_approved', 'Event Approved', 'Your event Tech Summit 2025 has been approved!', '/organizer/pages/events.php', 1);

-- Update ticket sold counts
UPDATE ticket_types SET sold = quantity - available WHERE event_id IN (@event1, @event2, @event3, @event4, @event6);

