<?php
/**
 * Configuration file for beLIVE Events
 */

// Database configuration
// define('DB_HOST', '20.193.252.200');
// define('DB_NAME', 'db_events');
// define('DB_USER', 'sms-belive');
// define('DB_PASS', 'skhcihy@63426');

define('DB_HOST', 'localhost');
define('DB_NAME', 'db_events');
define('DB_USER', 'root');
define('DB_PASS', 'root');

// Session configuration
define('SESSION_LIFETIME', 86400); // 24 hours

// Base URL - Auto-detect from current request
// Works for both local (http://localhost/events_belive) and production (https://belive-events.videostech.cloud)
if (!defined('BASE_URL')) {
    // Check if we're in a web request
    if (isset($_SERVER['HTTP_HOST'])) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || 
                     (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')) 
                     ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        
        // Determine base path - prioritize domain-based detection for production
        $basePath = '';
        $isProduction = false;
        
        // PRODUCTION: For production domain, always use root path (NO /events_belive)
        if (strpos($host, 'belive-events.videostech.cloud') !== false) {
            $basePath = ''; // Production - root domain, no subfolder
            $isProduction = true;
        }
        // Alternative production domain
        elseif (strpos($host, 'recognizer.multitvsolution.com') !== false || strpos($host, 'multitvsolution.com') !== false) {
            $basePath = '/events'; // Alternative production path
            $isProduction = true;
        }
        
        // LOCAL/DEV: Only run path detection for non-production environments
        if (!$isProduction) {
            // Method 1: Check REQUEST_URI first (most reliable for local)
            if (isset($_SERVER['REQUEST_URI'])) {
                $requestUri = $_SERVER['REQUEST_URI'];
                // Extract /events_belive from REQUEST_URI if present
                if (preg_match('#(/events_belive)#', $requestUri, $matches)) {
                    $basePath = $matches[1];
                }
            }
            
            // Method 2: If not found in REQUEST_URI, check SCRIPT_NAME
            if ($basePath === '' && isset($_SERVER['SCRIPT_NAME'])) {
                $scriptName = $_SERVER['SCRIPT_NAME'];
                
                // Extract base path from script location
                if (preg_match('#(/events_belive)#', $scriptName, $matches)) {
                    $basePath = $matches[1];
                }
                // Or extract from folder structure
                elseif (preg_match('#(/[^/]+)?/(admin|api|organizer|venue)/#', $scriptName, $matches)) {
                    $basePath = $matches[1] ?? '';
                }
                
                // Normalize: remove trailing slashes
                $basePath = rtrim($basePath, '/');
            }
            
            // Method 3: Fallback - check directory structure
            if ($basePath === '') {
                // Check if we're in events_belive directory
                if (strpos(__DIR__, 'events_belive') !== false || 
                    (isset($_SERVER['DOCUMENT_ROOT']) && strpos($_SERVER['DOCUMENT_ROOT'], 'events_belive') !== false)) {
                    $basePath = '/events_belive';
                }
            }
        }
        
        define('BASE_URL', $protocol . '://' . $host . $basePath);
    } else {
        // Fallback for CLI or when HTTP_HOST is not set
        // Try to detect from environment
        if (strpos(__DIR__, 'events_belive') !== false) {
            define('BASE_URL', 'http://localhost/events_belive');
        } else {
            define('BASE_URL', 'https://belive-events.videostech.cloud');
        }
    }
}

// OAuth Configuration
// Google OAuth
define('GOOGLE_CLIENT_ID', getenv('GOOGLE_CLIENT_ID') ?: '848327141592-lnkqf85orv7tp6lb1bm2ggck4m874794.apps.googleusercontent.com');
define('GOOGLE_CLIENT_SECRET', getenv('GOOGLE_CLIENT_SECRET') ?: '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');
define('GOOGLE_REDIRECT_URI', getenv('GOOGLE_REDIRECT_URI') ?: BASE_URL . '/api/auth/google-callback.php');

// Facebook OAuth
define('FACEBOOK_APP_ID', getenv('FACEBOOK_APP_ID') ?: '1843045946575277');
define('FACEBOOK_APP_SECRET', getenv('FACEBOOK_APP_SECRET') ?: '92ad39c88ab0190833b70fefb59aef9f');
define('FACEBOOK_REDIRECT_URI', getenv('FACEBOOK_REDIRECT_URI') ?: BASE_URL . '/api/auth/facebook-callback.php');

// LinkedIn OAuth
define('LINKEDIN_CLIENT_ID', getenv('LINKEDIN_CLIENT_ID') ?: '86027avvd0ox4e');
define('LINKEDIN_CLIENT_SECRET', getenv('LINKEDIN_CLIENT_SECRET') ?: 'WPL_AP1.qUfgCcXnV2VihPWm.tWILmA==');
define('LINKEDIN_REDIRECT_URI', getenv('LINKEDIN_REDIRECT_URI') ?: BASE_URL . '/api/auth/linkedin-callback.php');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    // Configure session settings
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    ini_set('session.cookie_lifetime', SESSION_LIFETIME);
    session_start();
    
    // Regenerate session ID periodically for security
    if (!isset($_SESSION['created'])) {
        $_SESSION['created'] = time();
    } else if (time() - $_SESSION['created'] > 1800) {
        // Regenerate session ID every 30 minutes
        session_regenerate_id(true);
        $_SESSION['created'] = time();
    }
}
