<?php
/**
 * Check Migration Status
 * Run this to check if roles and permissions tables exist
 */

require_once __DIR__ . '/config.php';

try {
    $pdo = getDB();
    
    echo "<h2>Migration Status Check</h2>\n";
    echo "<pre>\n";
    
    // Check tables
    $tables = ['roles', 'permissions', 'role_permissions', 'user_roles'];
    
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Table '$table' exists\n";
            
            // Show structure
            $stmt = $pdo->query("DESCRIBE $table");
            $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "   Columns: " . implode(', ', array_column($columns, 'Field')) . "\n";
            
            // Count rows
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM $table");
            $count = $stmt->fetch(PDO::FETCH_ASSOC);
            echo "   Rows: " . $count['count'] . "\n\n";
        } else {
            echo "❌ Table '$table' does NOT exist\n\n";
        }
    }
    
    // Check user_roles data
    echo "\n=== User Roles Assignments ===\n";
    $stmt = $pdo->query("
        SELECT 
            ur.id,
            ur.user_id,
            c.email as user_email,
            ur.role_id,
            r.name as role_name,
            ur.user_type,
            ur.created_at
        FROM user_roles ur
        LEFT JOIN customers c ON ur.user_id = c.id
        LEFT JOIN roles r ON ur.role_id = r.id
        ORDER BY ur.created_at DESC
        LIMIT 20
    ");
    $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($assignments) > 0) {
        echo "Found " . count($assignments) . " role assignments:\n";
        foreach ($assignments as $assignment) {
            echo sprintf(
                "  User ID: %d (%s) → Role: %s (ID: %d) [Type: %s] - Created: %s\n",
                $assignment['user_id'],
                $assignment['user_email'] ?? 'N/A',
                $assignment['role_name'] ?? 'N/A',
                $assignment['role_id'],
                $assignment['user_type'] ?? 'N/A',
                $assignment['created_at']
            );
        }
    } else {
        echo "⚠️ No role assignments found in database\n";
        echo "   Run migration: http://localhost/events_belive/run_roles_migration.php?key=migrate_roles_2024\n";
    }
    
    echo "\n</pre>\n";
    
} catch (Exception $e) {
    echo "<pre>Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n</pre>";
}



