// Authentication JavaScript

let currentUser = null;

// Check authentication status on page load
document.addEventListener('DOMContentLoaded', function() {
    checkAuthStatus();
});

// Check if user is authenticated
async function checkAuthStatus() {
    try {
        const response = await fetch('api/public/authcheckapi.php');
        const data = await response.json();
        
        if (data.success && data.authenticated) {
            currentUser = data.user;
            updateNavigation(true, data.user);
        } else {
            updateNavigation(false, null);
        }
    } catch (error) {
        console.error('Error checking auth status:', error);
        updateNavigation(false, null);
    }
}

// Update navigation based on auth status
function updateNavigation(isLoggedIn, user) {
    const nav = document.querySelector('.nav');
    if (!nav) return;
    
    // Remove existing auth links
    const existingAuthLink = nav.querySelector('.auth-link');
    if (existingAuthLink) {
        existingAuthLink.remove();
    }
    
    // Create auth link
    const authLink = document.createElement('a');
    authLink.className = 'nav-link auth-link';
    
    if (isLoggedIn && user) {
        // Show user menu
        authLink.href = '#';
        authLink.innerHTML = `
            <span class="user-menu">
                <span class="user-name">${escapeHtml(user.full_name || user.email || 'User')}</span>
                <span class="user-dropdown">▼</span>
            </span>
        `;
        
        // Create dropdown menu
        const dropdown = document.createElement('div');
        dropdown.className = 'user-dropdown-menu';
        dropdown.innerHTML = `
            <a href="profile.html" class="dropdown-item">My Profile</a>
            <a href="api/auth/logout.php" class="dropdown-item">Logout</a>
        `;
        authLink.appendChild(dropdown);
        
        // Toggle dropdown on click (but not on dropdown items)
        authLink.addEventListener('click', function(e) {
            // Don't prevent default if clicking on a dropdown item
            if (e.target.classList.contains('dropdown-item')) {
                return; // Let the link work normally
            }
            e.preventDefault();
            dropdown.classList.toggle('show');
        });
        
        // Ensure dropdown items work correctly
        dropdown.addEventListener('click', function(e) {
            if (e.target.classList.contains('dropdown-item')) {
                // Allow the link to navigate normally
                dropdown.classList.remove('show');
            }
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!authLink.contains(e.target)) {
                dropdown.classList.remove('show');
            }
        });
    } else {
        // Show login link
        authLink.href = 'login.html';
        authLink.textContent = 'Login';
    }
    
    nav.appendChild(authLink);
}

// Escape HTML
function escapeHtml(text) {
    if (!text) return '';
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Get current user (for use in other scripts)
function getCurrentUser() {
    return currentUser;
}
