<?php
/**
 * Venue Update Profile API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireVenue();

// Check permission to edit profile
if (!hasPermission('venue.profile.edit')) {
    sendError('You do not have permission to edit profile.', 403);
}

try {
    $venue = getCurrentVenue();
    $pdo = getDB();
    
    $method = $_SERVER['REQUEST_METHOD'];
    
    if ($method === 'POST' || $method === 'PUT' || $method === 'PATCH') {
        $data = getRequestData();
        
        // Build update query dynamically based on provided fields
        $updateFields = [];
        $updateParams = [':id' => $venue['id']];
        
        $allowedFields = ['venue_name', 'description', 'contact_email', 'contact_phone', 
                         'address', 'city', 'state', 'country', 'capacity', 
                         'venue_rules', 'accessibility_details'];
        
        foreach ($allowedFields as $field) {
            if (isset($data[$field])) {
                $updateFields[] = "{$field} = :{$field}";
                $updateParams[":{$field}"] = $data[$field];
            }
        }
        
        if (empty($updateFields)) {
            sendError('No fields to update', 400);
        }
        
        $updateFields[] = "updated_at = NOW()";
        $sql = "UPDATE venues SET " . implode(', ', $updateFields) . " WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute($updateParams);
        
        sendSuccess([
            'message' => 'Profile updated successfully'
        ]);
    } else {
        sendError('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log('Venue Update Profile API Error: ' . $e->getMessage());
    sendError('Failed to update profile', 500);
}

