<?php
/**
 * Categories API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';

try {
    $pdo = getDB();
    
    $stmt = $pdo->prepare("
        SELECT * FROM categories 
        WHERE is_active = 1 
        ORDER BY name ASC
    ");
    $stmt->execute();
    $categories = $stmt->fetchAll();
    
    sendSuccess(['categories' => $categories]);
} catch (Exception $e) {
    error_log('Categories API Error: ' . $e->getMessage());
    sendError('Failed to load categories', 500);
}

