<?php
/**
 * Auth Check API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';

try {
    if (isLoggedIn()) {
        $user = getCurrentUser();
        sendSuccess([
            'authenticated' => true,
            'user' => [
                'id' => $user['id'],
                'email' => $user['email'],
                'full_name' => $user['full_name'],
                'profile_picture' => $user['profile_picture']
            ]
        ]);
    } else {
        sendSuccess([
            'authenticated' => false,
            'user' => null
        ]);
    }
} catch (Exception $e) {
    error_log('Auth Check API Error: ' . $e->getMessage());
    sendSuccess([
        'authenticated' => false,
        'user' => null
    ]);
}

