<?php
/**
 * About Us API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';

try {
    $pdo = getDB();
    
    // Get about us content from CMS
    $stmt = $pdo->prepare("SELECT * FROM cms_content WHERE page_slug = 'about-us' AND is_active = 1");
    $stmt->execute();
    $content = $stmt->fetch();
    
    if ($content) {
        sendSuccess([
            'title' => $content['page_title'],
            'content' => $content['content'],
            'meta_title' => $content['meta_title'],
            'meta_description' => $content['meta_description']
        ]);
    } else {
        // Default content if not found in CMS
        sendSuccess([
            'title' => 'About beLIVE EventsHUB',
            'content' => '<p>beLIVE EventsHUB is a unified event management platform designed to bridge the gap between event organizers and attendees. We provide a seamless experience for discovering, managing, and attending events worldwide.</p><p>Our platform empowers small to medium-scale event organizers with powerful tools to digitize ticket sales, manage events, and grow their audience.</p>',
            'meta_title' => 'About Us - beLIVE EventsHUB',
            'meta_description' => 'Learn about beLIVE EventsHUB, a modern event listing and management platform.'
        ]);
    }
} catch (Exception $e) {
    error_log('About Us API Error: ' . $e->getMessage());
    sendError('Failed to load about us content', 500);
}

