<?php
/**
 * Organizer Settings API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireOrganizer();

try {
    $organizer = getCurrentOrganizer();
    $pdo = getDB();
    
    $method = $_SERVER['REQUEST_METHOD'];
    
    if ($method === 'GET') {
        // Check permission to view settings
        if (!hasPermission('organizer.settings.view')) {
            sendError('You do not have permission to view settings.', 403);
        }
        
        // Get organizer profile
        $stmt = $pdo->prepare("
            SELECT o.*, c.email as user_email, c.full_name as user_name
            FROM organizers o
            INNER JOIN customers c ON o.user_id = c.id
            WHERE o.id = :organizer_id
        ");
        $stmt->execute([':organizer_id' => $organizer['id']]);
        $profile = $stmt->fetch(PDO::FETCH_ASSOC);
        
        sendSuccess([
            'profile' => $profile
        ]);
    } elseif ($method === 'POST' || $method === 'PUT' || $method === 'PATCH') {
        // Check permission to edit settings
        if (!hasPermission('organizer.settings.edit')) {
            sendError('You do not have permission to edit settings.', 403);
        }
        
        // Update settings
        $data = getRequestData();
        // Update organizer profile
        sendSuccess(['message' => 'Settings updated successfully']);
    } else {
        sendError('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log('Organizer Settings API Error: ' . $e->getMessage());
    sendError('Failed to process request', 500);
}

