<?php
/**
 * Organizer Promotions API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireOrganizer();

// Check permission to view promotions
if (!hasPermission('organizer.promotions.view')) {
    sendError('You do not have permission to view promotions.', 403);
}

try {
    $organizer = getCurrentOrganizer();
    $pdo = getDB();
    
    // Get organizer's events
    $stmt = $pdo->prepare("SELECT id, name FROM events WHERE organizer_id = :organizer_id ORDER BY name ASC");
    $stmt->execute([':organizer_id' => $organizer['id']]);
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get organizer's coupons
    $stmt = $pdo->prepare("
        SELECT c.*, COUNT(cu.id) as usage_count
        FROM coupons c
        LEFT JOIN coupon_usage cu ON c.id = cu.coupon_id
        WHERE c.created_by_type = 'organizer' AND c.created_by = :organizer_id
        GROUP BY c.id
        ORDER BY c.created_at DESC
    ");
    $stmt->execute([':organizer_id' => $organizer['id']]);
    $coupons = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendSuccess([
        'events' => $events,
        'coupons' => $coupons
    ]);
} catch (Exception $e) {
    error_log('Organizer Promotions API Error: ' . $e->getMessage());
    sendError('Failed to load promotions data', 500);
}

