<?php
/**
 * Facebook OAuth Login - Initiate OAuth flow
 */

require_once __DIR__ . '/../../config.php';

// Check if Facebook OAuth is configured
if (empty(FACEBOOK_APP_ID) || empty(FACEBOOK_APP_SECRET)) {
    header('Location: ../../login.html?error=' . urlencode('Facebook OAuth is not configured. Please set FACEBOOK_APP_ID and FACEBOOK_APP_SECRET in environment variables.'));
    exit;
}

// Generate state token for CSRF protection
$state = bin2hex(random_bytes(16));
$_SESSION['oauth_state'] = $state;
$_SESSION['oauth_provider'] = 'facebook';

// Build Facebook OAuth URL
$params = [
    'client_id' => FACEBOOK_APP_ID,
    'redirect_uri' => FACEBOOK_REDIRECT_URI,
    'state' => $state,
    'scope' => 'email,public_profile,user_location,user_hometown,user_likes,user_interests,user_education_history,user_work_history',
    'response_type' => 'code'
];

$authUrl = 'https://www.facebook.com/v18.0/dialog/oauth?' . http_build_query($params);

// Redirect to Facebook
header('Location: ' . $authUrl);
exit;
