<?php
/**
 * Admin Wallet & BNPL API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    // Get wallet statistics
    $stmt = $pdo->query("
        SELECT 
            COUNT(*) as total_wallets,
            COALESCE(SUM(balance), 0) as total_balance,
            COUNT(CASE WHEN balance > 0 THEN 1 END) as active_wallets
        FROM wallets
    ");
    $wallet_stats = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Get filter parameters
    $page = (int)($_GET['page'] ?? 1);
    $limit = (int)($_GET['limit'] ?? 50);
    $offset = ($page - 1) * $limit;
    
    // Get recent transactions
    $stmt = $pdo->prepare("
        SELECT 
            wt.*,
            w.customer_id,
            c.email as customer_email,
            c.full_name as customer_name
        FROM wallet_transactions wt
        INNER JOIN wallets w ON wt.wallet_id = w.id
        INNER JOIN customers c ON w.customer_id = c.id
        ORDER BY wt.created_at DESC
        LIMIT :limit OFFSET :offset
    ");
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get total count
    $countStmt = $pdo->query("SELECT COUNT(*) as total FROM wallet_transactions");
    $totalResult = $countStmt->fetch(PDO::FETCH_ASSOC);
    $total = (int)($totalResult['total'] ?? 0);
    
    sendSuccess([
        'wallet_stats' => $wallet_stats,
        'transactions' => $transactions,
        'pagination' => [
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
            'pages' => ceil($total / $limit)
        ]
    ]);
} catch (Exception $e) {
    error_log('Admin Wallet API Error: ' . $e->getMessage());
    sendError('Failed to load wallet data', 500);
}

