<?php
/**
 * Admin Financial Settlements API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    // Get settlement statistics (calculate from bookings if settlements table doesn't exist)
    try {
        $stmt = $pdo->query("
            SELECT 
                COUNT(DISTINCT o.id) as total_organizers,
                COALESCE(SUM(b.final_amount), 0) as total_revenue,
                COALESCE(SUM(b.final_amount * 0.1), 0) as platform_commission,
                COALESCE(SUM(b.final_amount * 0.9), 0) as organizer_payout
            FROM bookings b
            INNER JOIN events e ON b.event_id = e.id
            INNER JOIN organizers o ON e.organizer_id = o.id
            WHERE b.payment_status = 'completed'
        ");
        $settlement_stats = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Get organizer settlements
        $stmt = $pdo->query("
            SELECT 
                o.id as organizer_id,
                o.company_name,
                SUM(b.final_amount) as total_revenue,
                SUM(b.final_amount * 0.1) as commission,
                SUM(b.final_amount * 0.9) as payout,
                COUNT(b.id) as total_bookings
            FROM bookings b
            INNER JOIN events e ON b.event_id = e.id
            INNER JOIN organizers o ON e.organizer_id = o.id
            WHERE b.payment_status = 'completed'
            GROUP BY o.id
            ORDER BY total_revenue DESC
        ");
        $organizer_settlements = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        $settlement_stats = [
            'total_organizers' => 0,
            'total_revenue' => 0,
            'platform_commission' => 0,
            'organizer_payout' => 0
        ];
        $organizer_settlements = [];
    }
    
    sendSuccess([
        'settlement_stats' => $settlement_stats,
        'organizer_settlements' => $organizer_settlements
    ]);
} catch (Exception $e) {
    error_log('Admin Settlements API Error: ' . $e->getMessage());
    sendError('Failed to load settlement data', 500);
}

