<?php
/**
 * Admin Settings API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    $method = $_SERVER['REQUEST_METHOD'];
    
    if ($method === 'GET') {
        // Get platform settings (you can create a settings table later)
        sendSuccess([
            'settings' => [
                'platform_name' => 'beLIVE EventsHUB',
                'commission_rate' => 10,
                'currency' => 'AED',
                'timezone' => 'Asia/Dubai'
            ]
        ]);
    } elseif ($method === 'POST') {
        // Update settings
        $data = getRequestData();
        // In future, save to settings table
        sendSuccess(['message' => 'Settings updated successfully']);
    } else {
        sendError('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log('Admin Settings API Error: ' . $e->getMessage());
    sendError('Failed to process request', 500);
}

