<?php
/**
 * Admin Organizers API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    // Get filter parameters
    $status = $_GET['status'] ?? 'all';
    $search = $_GET['search'] ?? '';
    $page = (int)($_GET['page'] ?? 1);
    $limit = (int)($_GET['limit'] ?? 100);
    $offset = ($page - 1) * $limit;
    
    // Build query
    $where = [];
    $params = [];
    
    if ($status !== 'all') {
        if ($status === 'active') {
            $where[] = "o.is_active = 1";
        } elseif ($status === 'inactive') {
            $where[] = "o.is_active = 0";
        } elseif ($status === 'verified') {
            $where[] = "o.kyc_status = 'verified'";
        } elseif ($status === 'pending') {
            $where[] = "o.kyc_status = 'pending'";
        }
    }
    
    if ($search) {
        $where[] = "(o.company_name LIKE :search OR o.contact_email LIKE :search OR c.email LIKE :search)";
        $params[':search'] = '%' . $search . '%';
    }
    
    $whereClause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';
    
    // Get total count
    $countStmt = $pdo->prepare("SELECT COUNT(*) as total FROM organizers o LEFT JOIN customers c ON o.user_id = c.id {$whereClause}");
    $countStmt->execute($params);
    $totalResult = $countStmt->fetch(PDO::FETCH_ASSOC);
    $total = (int)($totalResult['total'] ?? 0);
    
    // Get organizers
    $stmt = $pdo->prepare("
        SELECT 
            o.*,
            c.email as user_email,
            c.full_name as user_name,
            COUNT(DISTINCT e.id) as total_events
        FROM organizers o
        LEFT JOIN customers c ON o.user_id = c.id
        LEFT JOIN events e ON o.id = e.organizer_id
        {$whereClause}
        GROUP BY o.id
        ORDER BY o.created_at DESC
        LIMIT :limit OFFSET :offset
    ");
    
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $organizers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendSuccess([
        'organizers' => $organizers,
        'pagination' => [
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
            'pages' => ceil($total / $limit)
        ]
    ]);
} catch (Exception $e) {
    error_log('Admin Organizers API Error: ' . $e->getMessage());
    sendError('Failed to load organizers', 500);
}

