<?php
/**
 * Admin Notifications API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    $method = $_SERVER['REQUEST_METHOD'];
    
    if ($method === 'GET') {
        // Get notifications
        $page = (int)($_GET['page'] ?? 1);
        $limit = (int)($_GET['limit'] ?? 100);
        $offset = ($page - 1) * $limit;
        
        $stmt = $pdo->prepare("
            SELECT * FROM notifications 
            ORDER BY created_at DESC
            LIMIT :limit OFFSET :offset
        ");
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
        $stmt->execute();
        $notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Get statistics
        $statsStmt = $pdo->query("
            SELECT 
                COUNT(*) as total,
                COUNT(CASE WHEN is_read = 0 THEN 1 END) as unread
            FROM notifications
        ");
        $stats = $statsStmt->fetch(PDO::FETCH_ASSOC);
        
        $countStmt = $pdo->query("SELECT COUNT(*) as total FROM notifications");
        $totalResult = $countStmt->fetch(PDO::FETCH_ASSOC);
        $total = (int)($totalResult['total'] ?? 0);
        
        sendSuccess([
            'notifications' => $notifications,
            'stats' => $stats,
            'pagination' => [
                'total' => $total,
                'page' => $page,
                'limit' => $limit,
                'pages' => ceil($total / $limit)
            ]
        ]);
    } elseif ($method === 'POST') {
        // Send notification
        $data = getRequestData();
        $errors = validateRequired($data, ['user_type', 'type', 'title', 'message']);
        if (!empty($errors)) {
            sendError('Validation failed', 400, $errors);
        }
        
        $stmt = $pdo->prepare("
            INSERT INTO notifications (user_type, type, title, message, link, is_read, created_at)
            VALUES (:user_type, :type, :title, :message, :link, 0, NOW())
        ");
        $stmt->execute([
            ':user_type' => $data['user_type'],
            ':type' => $data['type'],
            ':title' => $data['title'],
            ':message' => $data['message'],
            ':link' => $data['link'] ?? null
        ]);
        
        sendSuccess(['message' => 'Notification sent successfully']);
    } else {
        sendError('Method not allowed', 405);
    }
} catch (Exception $e) {
    error_log('Admin Notifications API Error: ' . $e->getMessage());
    sendError('Failed to process request', 500);
}

