<?php
/**
 * Admin CMS & Content API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    // Get CMS pages (check if table exists, use cms_content if cms_pages doesn't exist)
    try {
        $stmt = $pdo->query("
            SELECT * FROM cms_pages 
            ORDER BY page_slug ASC
        ");
        $pages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        // Fallback to cms_content if cms_pages doesn't exist
        try {
            $stmt = $pdo->query("
                SELECT * FROM cms_content 
                ORDER BY page_slug ASC
            ");
            $pages = $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (Exception $e2) {
            $pages = [];
        }
    }
    
    // Get banners
    $stmt = $pdo->query("
        SELECT * FROM banners 
        ORDER BY `order` ASC, created_at DESC
    ");
    $banners = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendSuccess([
        'pages' => $pages,
        'banners' => $banners
    ]);
} catch (Exception $e) {
    error_log('Admin CMS API Error: ' . $e->getMessage());
    sendError('Failed to load CMS data', 500);
}

