<?php
/**
 * Approve Event API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireAdmin();

// Check permission to approve events
if (!hasPermission('events.approve') && !isSuperAdmin()) {
    sendError('You do not have permission to approve events.', 403);
}

$eventId = $_GET['id'] ?? null;

if (!$eventId) {
    sendError('Event ID is required', 400);
}

try {
    $pdo = getDB();
    
    // Update event status
    $stmt = $pdo->prepare("UPDATE events SET status = 'approved', updated_at = NOW() WHERE id = :id");
    $stmt->execute([':id' => $eventId]);
    
    if ($stmt->rowCount() > 0) {
        sendSuccess(['message' => 'Event approved successfully'], 'Event approved');
    } else {
        sendError('Event not found', 404);
    }
} catch (Exception $e) {
    error_log('Approve Event API Error: ' . $e->getMessage());
    sendError('Failed to approve event', 500);
}

