<?php
/**
 * Admin Analytics & Reports API
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/api_helper.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

try {
    $pdo = getDB();
    
    // Get analytics data
    $stmt = $pdo->query("
        SELECT 
            COUNT(DISTINCT e.id) as total_events,
            COUNT(DISTINCT b.id) as total_bookings,
            COALESCE(SUM(b.final_amount), 0) as total_revenue,
            COUNT(DISTINCT b.customer_id) as unique_customers,
            COALESCE(AVG(b.final_amount), 0) as avg_booking_value
        FROM events e
        LEFT JOIN bookings b ON e.id = b.event_id AND b.payment_status = 'completed'
    ");
    $analytics = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Get revenue by month (last 12 months)
    $revenueStmt = $pdo->query("
        SELECT 
            DATE_FORMAT(b.created_at, '%Y-%m') as month,
            SUM(b.final_amount) as revenue,
            COUNT(b.id) as bookings
        FROM bookings b
        WHERE b.payment_status = 'completed'
        AND b.created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
        GROUP BY DATE_FORMAT(b.created_at, '%Y-%m')
        ORDER BY month DESC
    ");
    $revenue_by_month = $revenueStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get events by category
    $categoryStmt = $pdo->query("
        SELECT 
            e.category,
            COUNT(*) as event_count,
            SUM(b.final_amount) as revenue
        FROM events e
        LEFT JOIN bookings b ON e.id = b.event_id AND b.payment_status = 'completed'
        GROUP BY e.category
        ORDER BY revenue DESC
    ");
    $events_by_category = $categoryStmt->fetchAll(PDO::FETCH_ASSOC);
    
    sendSuccess([
        'analytics' => $analytics,
        'revenue_by_month' => $revenue_by_month,
        'events_by_category' => $events_by_category
    ]);
} catch (Exception $e) {
    error_log('Admin Analytics API Error: ' . $e->getMessage());
    sendError('Failed to load analytics data', 500);
}

