<?php
/**
 * Admin - User Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireAdmin();

// Check permission
if (!hasPermission('users.view') && !isSuperAdmin()) {
    header('Location: ' . BASE_URL . '/admin/dashboard.php?error=' . urlencode('Insufficient permissions'));
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'users';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>User Management</h1>
                
                <!-- Filters -->
                <div class="section">
                    <form id="filterForm" method="GET" style="display: flex; gap: 1rem; align-items: end;">
                        <div class="form-group" style="flex: 1;">
                            <label>Search</label>
                            <input type="text" name="search" value="" placeholder="Search by name or email...">
                        </div>
                        <div class="form-group" style="width: 200px;">
                            <label>Status</label>
                            <select name="status">
                                <option value="all">All</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <div class="form-group" style="width: auto;">
                            <button type="submit" class="btn-sm btn-primary">Filter</button>
                        </div>
                    </form>
                </div>
                
                <!-- Users Table -->
                <div class="section">
                    <div class="table-container" id="usersTableContainer1">
                        <table class="data-table" id="usersTable1">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Type</th>
                                    <th>Roles</th>
                                    <th>Provider</th>
                                    <th>Bookings</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="10" style="text-align: center; padding: 2rem;">Loading users...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    
    
    

    <!-- Role Assignment Modal -->
    <div id="roleAssignmentModal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: white; border-radius: 12px; padding: 2rem; max-width: 600px; width: 90%;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h2 id="roleModalTitle">Assign Roles</h2>
                <button id="closeRoleModal" style="background: none; border: none; font-size: 1.5rem; cursor: pointer;">&times;</button>
            </div>
            
            <div id="roleModalUserInfo" style="margin-bottom: 1.5rem; padding: 1rem; background: #f9fafb; border-radius: 8px;">
                <!-- User info will be populated here -->
            </div>
            
            <div class="form-group">
                <label>Select Role to Assign</label>
                <select id="roleSelect" class="form-group" style="width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px;">
                    <option value="">-- Select Role --</option>
                </select>
            </div>
            
            <div class="form-group" style="margin-top: 1rem;">
                <label>Current Roles</label>
                <div id="currentRolesList" style="margin-top: 0.5rem;">
                    <!-- Current roles will be shown here -->
                </div>
            </div>
            
            <div style="display: flex; gap: 1rem; margin-top: 1.5rem;">
                <button id="assignRoleBtn" class="btn-sm btn-primary">Assign Role</button>
                <button id="cancelRoleModal" class="btn-sm btn-secondary">Close</button>
            </div>
        </div>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin.js"></script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-api.js"></script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-users.js"></script>
</body>
</html>

