<?php
/**
 * Admin - Financial Settlement
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Financial Settlement | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'settlements';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Financial Settlement</h1>
                
                <!-- Loading State -->
                <div id="settlementsContainer" style="text-align: center; padding: 2rem;">
                    <p>Loading settlement data...</p>
                </div>
                
                <!-- Statistics -->
                <div class="stats-grid" id="settlementStats" style="display: none;">
                    <div class="stat-card">
                        <div class="stat-icon">💰</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_organizers">0</div>
                            <div class="stat-label">Total Organizers</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">💵</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_revenue">$0.00</div>
                            <div class="stat-label">Total Revenue</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">📊</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="platform_commission">$0.00</div>
                            <div class="stat-label">Platform Commission</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">💸</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="organizer_payout">$0.00</div>
                            <div class="stat-label">Organizer Payout</div>
                        </div>
                    </div>
                </div>
                
                <!-- Settlements Table -->
                <div class="section" id="settlementsTableSection" style="display: none;">
                    <h2>Organizer Settlements</h2>
                    <div class="table-container">
                        <table class="data-table" id="settlementsTable">
                            <thead>
                                <tr>
                                    <th>Organizer</th>
                                    <th>Total Revenue</th>
                                    <th>Commission</th>
                                    <th>Payout</th>
                                    <th>Bookings</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6" style="text-align: center; padding: 2rem;">Loading settlements...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>
    
