<?php
/**
 * Admin - Settings
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'settings';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Settings</h1>
                
                <!-- Platform Settings -->
                <div class="section">
                    <h2>Platform Settings</h2>
                    <form>
                        <div class="form-group">
                            <label>Platform Name</label>
                            <input type="text" value="beLIVE EventsHUB" readonly>
                        </div>
                        <div class="form-group">
                            <label>Commission Rate (%)</label>
                            <input type="number" value="10" step="0.1" placeholder="Enter commission rate">
                        </div>
                        <div class="form-group">
                            <label>Platform Fee ($)</label>
                            <input type="number" value="0" step="0.01" placeholder="Enter platform fee">
                        </div>
                        <button type="submit" class="btn-sm btn-primary">Save Settings</button>
                    </form>
                </div>
                
                <!-- Email Settings -->
                <div class="section">
                    <h2>Email Settings</h2>
                    <form>
                        <div class="form-group">
                            <label>SMTP Host</label>
                            <input type="text" placeholder="smtp.example.com">
                        </div>
                        <div class="form-group">
                            <label>SMTP Port</label>
                            <input type="number" value="587" placeholder="587">
                        </div>
                        <div class="form-group">
                            <label>SMTP Username</label>
                            <input type="text" placeholder="your-email@example.com">
                        </div>
                        <div class="form-group">
                            <label>SMTP Password</label>
                            <input type="password" placeholder="Enter SMTP password">
                        </div>
                        <button type="submit" class="btn-sm btn-primary">Save Email Settings</button>
                    </form>
                </div>
                
                <!-- Payment Settings -->
                <div class="section">
                    <h2>Payment Gateway Settings</h2>
                    <form>
                        <div class="form-group">
                            <label>Payment Gateway</label>
                            <select>
                                <option>Stripe</option>
                                <option>PayPal</option>
                                <option>Razorpay</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>API Key</label>
                            <input type="text" placeholder="Enter API key">
                        </div>
                        <div class="form-group">
                            <label>API Secret</label>
                            <input type="password" placeholder="Enter API secret">
                        </div>
                        <button type="submit" class="btn-sm btn-primary">Save Payment Settings</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
    
    
    
    
    
    
    

    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>

