<?php
/**
 * Admin - Roles & Permissions Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/permissions.php';

requireAdmin();

// Check permission
if (!hasPermission('roles.view') && !isSuperAdmin()) {
    header('Location: ' . BASE_URL . '/admin/dashboard.php?error=' . urlencode('Insufficient permissions'));
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Roles & Permissions | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
    <style>
        .permission-group {
            margin-bottom: 2rem;
            padding: 1.5rem;
            background: #f9fafb;
            border-radius: 8px;
        }
        .permission-group h4 {
            margin-bottom: 1rem;
            color: #111827;
            font-size: 1.1rem;
        }
        .permission-item {
            display: flex;
            align-items: center;
            padding: 0.5rem;
            margin-bottom: 0.5rem;
        }
        .permission-item input[type="checkbox"] {
            margin-right: 0.75rem;
        }
        .role-actions {
            display: flex;
            gap: 0.5rem;
        }
    </style>
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'roles';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                    <h1>Roles & Permissions</h1>
                    <?php if (hasPermission('roles.create') || isSuperAdmin()): ?>
                    <button id="createRoleBtn" class="btn-sm btn-primary">+ Create Role</button>
                    <?php endif; ?>
                </div>
                
                <!-- Roles List -->
                <div class="section">
                    <h2>Roles</h2>
                    <div class="table-container">
                        <table class="data-table" id="rolesTable">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Slug</th>
                                    <th>Type</th>
                                    <th>Permissions</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="7" style="text-align: center; padding: 2rem;">Loading roles...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <!-- Create/Edit Role Modal -->
    <div id="roleModal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: white; border-radius: 12px; padding: 2rem; max-width: 800px; max-height: 90vh; overflow-y: auto; width: 90%;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
                <h2 id="modalTitle">Create Role</h2>
                <button id="closeModal" style="background: none; border: none; font-size: 1.5rem; cursor: pointer;">&times;</button>
            </div>
            
            <form id="roleForm">
                <input type="hidden" id="roleId" name="id">
                
                <div class="form-group">
                    <label>Role Name *</label>
                    <input type="text" id="roleName" name="name" required>
                </div>
                
                <div class="form-group">
                    <label>Slug * (lowercase, numbers, underscores only)</label>
                    <input type="text" id="roleSlug" name="slug" required pattern="[a-z0-9_]+">
                </div>
                
                <div class="form-group">
                    <label>Description</label>
                    <textarea id="roleDescription" name="description" rows="3"></textarea>
                </div>
                
                <div class="form-group">
                    <label>Status</label>
                    <select id="roleStatus" name="is_active">
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Permissions</label>
                    <div id="permissionsContainer"></div>
                </div>
                
                <div style="display: flex; gap: 1rem; margin-top: 1.5rem;">
                    <button type="submit" class="btn-sm btn-primary">Save Role</button>
                    <button type="button" id="cancelBtn" class="btn-sm btn-secondary">Cancel</button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin.js"></script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-api.js"></script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-roles.js"></script>
</body>
</html>



