<?php
/**
 * Admin - Organizers Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Organizers | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'organizers';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Organizers Management</h1>
                
                <!-- Filters -->
                <div class="section">
                    <form id="filterForm" method="GET" style="display: flex; gap: 1rem; align-items: end;">
                        <div class="form-group" style="flex: 1;">
                            <label>Search</label>
                            <input type="text" name="search" value="" placeholder="Search organizers...">
                        </div>
                        <div class="form-group" style="width: 200px;">
                            <label>Status</label>
                            <select name="status">
                                <option value="all">All</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="verified">Verified</option>
                                <option value="pending">Pending</option>
                            </select>
                        </div>
                        <div class="form-group" style="width: auto;">
                            <button type="submit" class="btn-sm btn-primary">Filter</button>
                        </div>
                    </form>
                </div>
                
                <!-- Organizers Table -->
                <div class="section">
                    <div class="table-container" id="organizersTableContainer">
                        <table class="data-table" id="organizersTable">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Company Name</th>
                                    <th>Contact Email</th>
                                    <th>User</th>
                                    <th>Events</th>
                                    <th>KYC Status</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="8" style="text-align: center; padding: 2rem;">Loading organizers...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    
    

    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>

