<?php
/**
 * Admin - Notifications Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';
require_once __DIR__ . '/../../includes/url_helper.php';

requireAdmin();
$baseUrl = getCorrectBaseUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifications | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'notifications';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Notifications Management</h1>
                
                <!-- Statistics -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">🔔</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_notifications">0</div>
                            <div class="stat-label">Total Notifications</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">📬</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="unread_notifications">0</div>
                            <div class="stat-label">Unread</div>
                        </div>
                    </div>
                </div>
                
                <!-- Send Notification -->
                <div class="section">
                    <h2>Send Notification</h2>
                    <form id="sendNotificationForm">
                        <div class="form-group">
                            <label for="user_type">User Type</label>
                            <select id="user_type" name="user_type" required>
                                <option value="">Select User Type</option>
                                <option value="customer">All Customers</option>
                                <option value="organizer">All Organizers</option>
                                <option value="venue">All Venues</option>
                                <option value="admin">All Admins</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="type">Notification Type</label>
                            <input type="text" id="type" name="type" placeholder="e.g., event_reminder, system_update" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="title">Title *</label>
                            <input type="text" id="title" name="title" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message *</label>
                            <textarea id="message" name="message" rows="4" required></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="link">Link (Optional)</label>
                            <input type="url" id="link" name="link" placeholder="https://example.com">
                        </div>
                        
                        <button type="submit" class="btn-sm btn-primary">Send Notification</button>
                    </form>
                </div>
                
                <!-- Recent Notifications -->
                <div class="section">
                    <h2>Recent Notifications</h2>
                    <div class="table-container" id="notificationsTableContainer">
                        <table class="data-table" id="notificationsTable">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>User Type</th>
                                    <th>Type</th>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6" style="text-align: center; padding: 2rem;">Loading notifications...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>
    
