<?php
/**
 * Admin - Loyalty & Memberships Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loyalty & Memberships | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'loyalty';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Loyalty & Memberships Management</h1>
                
                <!-- Statistics -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon">⭐</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_members">0</div>
                            <div class="stat-label">Total Members</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">🎯</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_points">0</div>
                            <div class="stat-label">Total Points</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">🥇</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="gold_members">0</div>
                            <div class="stat-label">Gold Members</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">💎</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="premium_members">0</div>
                            <div class="stat-label">Premium Members</div>
                        </div>
                    </div>
                </div>
                
                <!-- Filters -->
                <div class="section">
                    <form id="filterForm" style="display: flex; gap: 1rem; align-items: end;">
                        <div class="form-group" style="width: 200px;">
                            <label>Tier</label>
                            <select name="tier">
                                <option value="all">All Tiers</option>
                                <option value="gold">Gold</option>
                                <option value="premium">Premium</option>
                            </select>
                        </div>
                        <div class="form-group" style="width: auto;">
                            <button type="submit" class="btn-sm btn-primary">Filter</button>
                        </div>
                    </form>
                </div>
                
                <!-- Loyalty Points -->
                <div class="section">
                    <h2>Loyalty Points</h2>
                    <div class="table-container" id="loyaltyTableContainer">
                        <table class="data-table" id="loyaltyTable">
                            <thead>
                                <tr>
                                    <th>Customer</th>
                                    <th>Points</th>
                                    <th>Tier</th>
                                    <th>Updated</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="5" style="text-align: center; padding: 2rem;">Loading loyalty data...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>
    
