<?php
/**
 * Admin - Event Oversight
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Oversight | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'events';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Event Oversight</h1>
                
                <!-- Filters -->
                <div class="section">
                    <form id="filterForm" method="GET" style="display: flex; gap: 1rem; align-items: end;">
                        <div class="form-group" style="flex: 1;">
                            <label>Search</label>
                            <input type="text" name="search" value="" placeholder="Search events...">
                        </div>
                        <div class="form-group" style="width: 200px;">
                            <label>Status</label>
                            <select name="status">
                                <option value="all">All</option>
                                <option value="pending">Pending</option>
                                <option value="approved">Approved</option>
                                <option value="live">Live</option>
                                <option value="rejected">Rejected</option>
                            </select>
                        </div>
                        <div class="form-group" style="width: auto;">
                            <button type="submit" class="btn-sm btn-primary">Filter</button>
                        </div>
                    </form>
                </div>
                
                <!-- Events Table -->
                <div class="section">
                    <div class="table-container" id="eventsTableContainer">
                        <table class="data-table" id="eventsTable">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Event Name</th>
                                    <th>Organizer</th>
                                    <th>Venue</th>
                                    <th>Start Date</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="7" style="text-align: center; padding: 2rem;">Loading events...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    
    
    
    
    
    
    
    

    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>

