<?php
/**
 * Admin - CMS & Content Management
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CMS & Content | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'cms';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>CMS & Content Management</h1>
                
                <!-- Loading State -->
                <div id="cmsContainer" style="text-align: center; padding: 2rem;">
                    <p>Loading CMS data...</p>
                </div>
                
                <!-- CMS Pages -->
                <div class="section" id="pagesSection" style="display: none;">
                    <h2>CMS Pages</h2>
                    <div class="table-container">
                        <table class="data-table" id="pagesTable">
                            <thead>
                                <tr>
                                    <th>Page Slug</th>
                                    <th>Page Title</th>
                                    <th>Status</th>
                                    <th>Updated</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="5" style="text-align: center; padding: 2rem;">Loading pages...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Banners -->
                <div class="section" id="bannersSection" style="display: none;">
                    <h2>Banners</h2>
                    <div class="table-container">
                        <table class="data-table" id="bannersTable">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Position</th>
                                    <th>Order</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="6" style="text-align: center; padding: 2rem;">Loading banners...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>
    
