<?php
/**
 * Admin - Analytics & Reports
 */

require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/roles.php';

requireAdmin();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics & Reports | Admin Panel</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/admin/assets/css/admin.css">
</head>
<body class="admin-panel">
    <?php 
    $current_page = 'analytics';
    include __DIR__ . '/../includes/header.php'; 
    ?>
    
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="admin-content">
                <h1>Analytics & Reports</h1>
                
                <!-- Loading State -->
                <div id="analyticsContainer" style="text-align: center; padding: 2rem;">
                    <p>Loading analytics data...</p>
                </div>
                
                <!-- Statistics -->
                <div class="stats-grid" id="analyticsStats" style="display: none;">
                    <div class="stat-card">
                        <div class="stat-icon">📅</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_events">0</div>
                            <div class="stat-label">Total Events</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">🎟️</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_bookings">0</div>
                            <div class="stat-label">Total Bookings</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">💰</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="total_revenue">$0.00</div>
                            <div class="stat-label">Total Revenue</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">👥</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="unique_customers">0</div>
                            <div class="stat-label">Unique Customers</div>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon">📊</div>
                        <div class="stat-info">
                            <div class="stat-value" data-stat="avg_booking_value">$0.00</div>
                            <div class="stat-label">Avg Booking Value</div>
                        </div>
                    </div>
                </div>
                
                <!-- Revenue by Month -->
                <div class="section" id="revenueSection" style="display: none;">
                    <h2>Revenue by Month (Last 12 Months)</h2>
                    <div class="table-container">
                        <table class="data-table" id="revenueTable">
                            <thead>
                                <tr>
                                    <th>Month</th>
                                    <th>Revenue</th>
                                    <th>Bookings</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="3" style="text-align: center; padding: 2rem;">Loading...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Events by Category -->
                <div class="section" id="categorySection" style="display: none;">
                    <h2>Events by Category</h2>
                    <div class="table-container">
                        <table class="data-table" id="categoryTable">
                            <thead>
                                <tr>
                                    <th>Category</th>
                                    <th>Event Count</th>
                                    <th>Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="3" style="text-align: center; padding: 2rem;">Loading...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Reports Section -->
                <div class="section">
                    <h2>Generate Reports</h2>
                    <p>Report generation features will be available here. You can export data in CSV/Excel format.</p>
                    <div style="margin-top: 1rem;">
                        <button class="btn-sm btn-primary">Export Sales Report</button>
                        <button class="btn-sm btn-secondary" style="margin-left: 0.5rem;">Export User Report</button>
                        <button class="btn-sm btn-secondary" style="margin-left: 0.5rem;">Export Event Report</button>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script>
        const BASE_URL = '<?php echo BASE_URL; ?>';
    </script>
    <script src="<?php echo BASE_URL; ?>/admin/assets/js/admin-loader.js"></script>
</body>
</html>
    
