<?php
/**
 * Admin Login Page
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/roles.php';

// If already logged in as admin, redirect to dashboard
if (isAdmin()) {
    header('Location: ' . BASE_URL . '/admin/dashboard.php');
    exit;
}

$error = $_GET['error'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login | beLIVE EventsHUB</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/styles.css">
    <style>
        body {
            background: #f5f5f5;
            margin: 0;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
        }
        .admin-login-wrapper {
            display: flex;
            min-height: 100vh;
        }
        .admin-login-left {
            flex: 1;
            background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 4rem 5rem;
            color: white;
            position: relative;
            overflow: hidden;
        }
        .admin-login-left::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
            opacity: 0.3;
        }
        .admin-login-left-content {
            position: relative;
            z-index: 1;
            max-width: 600px;
        }
        .admin-logo-large {
            margin-bottom: 2rem;
        }
        .admin-logo-large img {
            height: 60px;
            filter: brightness(0) invert(1);
        }
        .admin-login-left h1 {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 1rem;
            line-height: 1.1;
            letter-spacing: -0.03em;
        }
        .admin-login-left h2 {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            opacity: 0.95;
        }
        .admin-login-left p {
            font-size: 1.125rem;
            line-height: 1.8;
            margin-bottom: 2.5rem;
            opacity: 0.9;
        }
        .admin-features {
            list-style: none;
            padding: 0;
            margin-top: 2rem;
        }
        .admin-features li {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.25rem;
            font-size: 1.05rem;
        }
        .admin-features li::before {
            content: '✓';
            width: 32px;
            height: 32px;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            flex-shrink: 0;
            font-size: 1.1rem;
        }
        .admin-login-right {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem;
            background: #fafafa;
        }
        .admin-login-card {
            background: white;
            border-radius: 20px;
            padding: 3.5rem;
            max-width: 480px;
            width: 100%;
            box-shadow: 0 10px 40px rgba(220, 38, 38, 0.12);
            border: 1px solid rgba(220, 38, 38, 0.15);
        }
        .admin-login-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        .admin-login-header h1 {
            font-size: 2rem;
            font-weight: 800;
            color: #dc2626;
            margin-bottom: 12px;
            letter-spacing: -0.02em;
        }
        .admin-login-header p {
            font-size: 1rem;
            color: #6b7280;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            color: #374151;
            font-weight: 500;
            font-size: 0.875rem;
        }
        .form-group input {
            width: 100%;
            padding: 0.875rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 1rem;
            box-sizing: border-box;
            transition: border-color 0.2s;
        }
        .form-group input:focus {
            outline: none;
            border-color: #dc2626;
            box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.1);
        }
        .btn-primary {
            width: 100%;
            padding: 0.875rem;
            background: #dc2626;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-primary:hover {
            background: #b91c1c;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
        }
        .error-message {
            background: #fee2e2;
            color: #dc2626;
            padding: 0.875rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            display: <?php echo $error ? 'block' : 'none'; ?>;
            font-size: 0.875rem;
            border: 1px solid #fecaca;
        }
        .back-link {
            text-align: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid #e5e7eb;
        }
        .back-link a {
            color: #6b7280;
            text-decoration: none;
            font-size: 0.875rem;
            transition: color 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        .back-link a:hover {
            color: #dc2626;
        }
        .admin-credentials {
            background: #f3f4f6;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1.5rem;
            font-size: 0.875rem;
        }
        .admin-credentials strong {
            color: #111827;
            display: block;
            margin-bottom: 0.5rem;
        }
        .admin-credentials code {
            background: white;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            color: #dc2626;
        }
        @media (max-width: 968px) {
            .admin-login-wrapper {
                flex-direction: column;
            }
            .admin-login-left {
                padding: 2.5rem;
                min-height: 50vh;
            }
            .admin-login-left h1 {
                font-size: 2.5rem;
            }
            .admin-login-left h2 {
                font-size: 1.25rem;
            }
            .admin-login-right {
                padding: 2rem;
            }
            .admin-login-card {
                padding: 2.5rem;
            }
        }
    </style>
</head>
<body class="admin-panel">
    <div class="admin-login-wrapper">
        <!-- Left Side - Branding & Features -->
        <div class="admin-login-left">
            <div class="admin-login-left-content">
                <div class="admin-logo-large">
                    <img src="https://events.videostech.cloud/_next/image?url=%2Fbelive-logo.png&w=1920&q=75" alt="beLIVE">
                </div>
                <h1>Welcome to<br>beLIVE Admin</h1>
                <h2>Manage your events, customers, and platform with powerful tools designed for efficiency and control.</h2>
                <p>Access comprehensive event management, customer insights, and platform controls all in one place.</p>
                
                <ul class="admin-features">
                    <li>Complete event management and moderation</li>
                    <li>Customer insights and analytics</li>
                    <li>Role-based access control</li>
                    <li>Real-time dashboard updates</li>
                </ul>
            </div>
        </div>
        
        <!-- Right Side - Login Form -->
        <div class="admin-login-right">
            <div class="admin-login-card">
                <div class="admin-login-header">
                    <h1>Admin Login</h1>
                    <p>Sign in to access the admin panel</p>
                </div>
                
                <div class="error-message" id="errorMessage" style="display: <?php echo $error ? 'block' : 'none'; ?>;">
                    <?php echo $error ? htmlspecialchars($error) : ''; ?>
                </div>
                
                <form id="adminLoginForm" method="POST" action="<?php echo BASE_URL; ?>/api/admin/loginapi.php">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email" required autocomplete="email" value="admin@belive.com">
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required autocomplete="current-password">
                    </div>
                    <button type="submit" class="btn-primary">Login</button>
                </form>
                
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const loginForm = document.getElementById('adminLoginForm');
                    if (!loginForm) return;
                    
                    loginForm.addEventListener('submit', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        
                        const formData = new FormData(this);
                        const submitBtn = this.querySelector('button[type="submit"]');
                        const originalText = submitBtn.textContent;
                        const errorMsg = document.getElementById('errorMessage');
                        
                        // Hide previous errors
                        if (errorMsg) {
                            errorMsg.style.display = 'none';
                        }
                        
                        submitBtn.disabled = true;
                        submitBtn.textContent = 'Logging in...';
                        
                        fetch(this.action, {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Network response was not ok');
                            }
                            return response.json();
                        })
                        .then(data => {
                            if (data.success && data.data && data.data.redirect) {
                                // Success - redirect
                                window.location.href = data.data.redirect;
                            } else {
                                // Show error
                                const errorMessage = data.message || 'Login failed. Please try again.';
                                if (errorMsg) {
                                    errorMsg.textContent = errorMessage;
                                    errorMsg.style.display = 'block';
                                } else {
                                    alert(errorMessage);
                                }
                                submitBtn.disabled = false;
                                submitBtn.textContent = originalText;
                            }
                        })
                        .catch(error => {
                            console.error('Login Error:', error);
                            const errorMessage = 'An error occurred. Please try again.';
                            if (errorMsg) {
                                errorMsg.textContent = errorMessage;
                                errorMsg.style.display = 'block';
                            } else {
                                alert(errorMessage);
                            }
                            submitBtn.disabled = false;
                            submitBtn.textContent = originalText;
                        });
                        
                        return false;
                    });
                });
                </script>
                
                <div class="admin-credentials">
                    <strong>Default Admin Credentials:</strong>
                    <div style="margin-top: 0.5rem;">
                        <strong>Email:</strong> <code>admin@belive.com</code><br>
                        <strong>Password:</strong> <code>admin123</code>
                    </div>
                </div>
                
                <div class="back-link">
                    <a href="<?php echo BASE_URL; ?>/index.html">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M19 12H5M12 19l-7-7 7-7"/>
                        </svg>
                        Back to Home
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

