<?php
/**
 * Admin Panel - Dashboard
 */

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/roles.php';

// Check if already logged in as admin
if (isAdmin()) {
    header('Location: ' . BASE_URL . '/admin/dashboard.php');
    exit;
}

// Redirect to login if not logged in
if (!isLoggedIn()) {
    header('Location: ' . BASE_URL . '/admin/login.php');
    exit;
}

// Check if user has admin role
$admin = isAdmin();
if (!$admin) {
    header('Location: ' . BASE_URL . '/login.html?error=' . urlencode('You do not have admin access'));
    exit;
}

header('Location: ' . BASE_URL . '/admin/dashboard.php');
exit;

