// Admin Panel JavaScript

document.addEventListener('DOMContentLoaded', function() {
    // Initialize any admin-specific functionality
    console.log('Admin panel loaded');
    
    // Handle form submissions with AJAX
    const forms = document.querySelectorAll('form[data-ajax]');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            handleAjaxForm(this);
        });
    });
});

function handleAjaxForm(form) {
    const formData = new FormData(form);
    const url = form.action;
    const method = form.method || 'POST';
    
    fetch(url, {
        method: method,
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (data.redirect) {
                window.location.href = data.redirect;
            } else {
                location.reload();
            }
        } else {
            alert(data.message || 'An error occurred');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred');
    });
}

