# beLIVE EventsHUB - Unified Event Management Platform

A comprehensive PHP-MySQL based event management platform with role-based admin panels for Admin, Organizer, and Venue users.

## Project Structure

```
events_belive/
├── admin/                    # Admin Panel
│   ├── pages/               # Admin pages
│   ├── includes/            # Header, sidebar includes
│   ├── assets/              # CSS, JS, images
│   ├── dashboard.php        # Admin dashboard
│   └── login.php            # Admin login
│
├── organizer/               # Organizer Panel
│   ├── pages/               # Organizer pages
│   ├── includes/            # Header, sidebar includes
│   ├── dashboard.php        # Organizer dashboard
│   └── index.php            # Organizer entry point
│
├── venue/                   # Venue Panel
│   ├── pages/               # Venue pages
│   ├── includes/            # Header, sidebar includes
│   ├── dashboard.php        # Venue dashboard
│   └── index.php            # Venue entry point
│
├── api/                     # API Endpoints
│   ├── admin/               # Admin APIs
│   ├── organizer/           # Organizer APIs
│   ├── venue/               # Venue APIs
│   └── public/              # Public APIs
│       ├── aboutusapi.php
│       ├── eventsapi.php
│       ├── eventdetailapi.php
│       ├── categoriesapi.php
│       └── authcheckapi.php
│
├── includes/                # Shared PHP includes
│   ├── auth.php             # Authentication functions
│   ├── roles.php            # Role-based access control
│   └── api_helper.php       # API helper functions
│
├── index.html               # Homepage
├── events.html              # Events listing
├── event-detail.html        # Event detail page
├── aboutus.html             # About Us page
├── login.html               # User login
├── config.php               # Configuration
└── database_schema.sql      # Database schema

```

## Database Configuration

Update `config.php` with your MySQL credentials:
- Host: localhost
- Database: db_events
- Username: root
- Password: mtv

## Installation

1. Import the database schema:
```bash
mysql -u root -pmtv db_events < database_schema.sql
```

2. Update `config.php` with your database credentials if different.

3. Set up web server (Apache/Nginx) to point to this directory.

4. Access the application:
   - Frontend: `http://localhost/events_belive/`
   - Admin Panel: `http://localhost/events_belive/admin/login.php`
   - Organizer Panel: `http://localhost/events_belive/organizer/`
   - Venue Panel: `http://localhost/events_belive/venue/`

## Default Admin Account

After importing the database schema, a default admin account is created:
- Email: admin@belive.com
- Password: (needs to be set via password reset or direct database update)

## Features

### Customer Portal
- Event discovery and browsing
- Event detail pages
- Social login (Google, Facebook, LinkedIn)
- User profiles

### Admin Panel
- User & Vendor Management
- Event Oversight & Approval
- Wallet & BNPL Control
- Loyalty & Membership Management
- Analytics & Reporting
- CMS & Content Management
- Financial Settlement & Reconciliation

### Organizer Panel
- Event Lifecycle Management
- Create & Manage Events
- Promotions & Marketing Tools
- Sales & Finance Dashboard
- Attendee Management

### Venue Panel
- Venue Profile Management
- Event & Occupancy Insights
- Revenue Analytics
- Access Control & Staff Management

## API Structure

Each page has a corresponding API file following the pattern:
- `aboutus.html` → `api/public/aboutusapi.php`
- `events.html` → `api/public/eventsapi.php`
- etc.

All APIs return JSON in the format:
```json
{
  "success": true,
  "message": "Success",
  "data": { ... }
}
```

## Role-Based Access

The system supports three main roles:
1. **Admin**: Full platform access
2. **Organizer**: Event creation and management
3. **Venue**: Venue management and insights

Users can have multiple roles (e.g., be both an organizer and venue owner).

## Social Login

The platform supports OAuth login via:
- Google
- Facebook
- LinkedIn

Configuration is in `config.php`.

## Development Notes

- All API endpoints are in the `api/` directory
- Frontend pages call their corresponding API files
- Role-based access is enforced via `includes/roles.php`
- Database connection is handled via `includes/auth.php`

## Next Steps

1. Set up payment gateway integration
2. Implement wallet and BNPL features
3. Add email/SMS notification system
4. Implement face recognition for ticket validation
5. Add AI recommendation engine integration
6. Set up analytics and reporting dashboards

